/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the query results from a <code>DescribeEvaluations</code> operation. The content is essentially a list of
 * <code>Evaluation</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEvaluationsResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DescribeEvaluationsResponse.Builder, DescribeEvaluationsResponse> {
    private final List<Evaluation> results;

    private final String nextToken;

    private DescribeEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>Evaluation</code> that meet the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Evaluation</code> that meet the search criteria.
     */
    public List<Evaluation> results() {
        return results;
    }

    /**
     * <p>
     * The ID of the next page in the paginated results that indicates at least one more page follows.
     * </p>
     * 
     * @return The ID of the next page in the paginated results that indicates at least one more page follows.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEvaluationsResponse)) {
            return false;
        }
        DescribeEvaluationsResponse other = (DescribeEvaluationsResponse) obj;
        return Objects.equals(results(), other.results()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeEvaluationsResponse").add("Results", results()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, DescribeEvaluationsResponse> {
        /**
         * <p>
         * A list of <code>Evaluation</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>Evaluation</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<Evaluation> results);

        /**
         * <p>
         * A list of <code>Evaluation</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>Evaluation</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Evaluation... results);

        /**
         * <p>
         * A list of <code>Evaluation</code> that meet the search criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Evaluation>.Builder} avoiding the need to
         * create one manually via {@link List<Evaluation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Evaluation>.Builder#build()} is called immediately and its
         * result is passed to {@link #results(List<Evaluation>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<Evaluation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<Evaluation>)
         */
        Builder results(Consumer<Evaluation.Builder>... results);

        /**
         * <p>
         * The ID of the next page in the paginated results that indicates at least one more page follows.
         * </p>
         * 
         * @param nextToken
         *        The ID of the next page in the paginated results that indicates at least one more page follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private List<Evaluation> results = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEvaluationsResponse model) {
            super(model);
            results(model.results);
            nextToken(model.nextToken);
        }

        public final Collection<Evaluation.Builder> getResults() {
            return results != null ? results.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<Evaluation> results) {
            this.results = EvaluationsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Evaluation... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<Evaluation.Builder>... results) {
            results(Stream.of(results).map(c -> Evaluation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<Evaluation.BuilderImpl> results) {
            this.results = EvaluationsCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEvaluationsResponse build() {
            return new DescribeEvaluationsResponse(this);
        }
    }
}
