/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RDSDatabaseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The database details of an Amazon RDS database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSDatabase implements StructuredPojo, ToCopyableBuilder<RDSDatabase.Builder, RDSDatabase> {
    private final String instanceIdentifier;

    private final String databaseName;

    private RDSDatabase(BuilderImpl builder) {
        this.instanceIdentifier = builder.instanceIdentifier;
        this.databaseName = builder.databaseName;
    }

    /**
     * <p>
     * The ID of an RDS DB instance.
     * </p>
     * 
     * @return The ID of an RDS DB instance.
     */
    public String instanceIdentifier() {
        return instanceIdentifier;
    }

    /**
     * Returns the value of the DatabaseName property for this object.
     * 
     * @return The value of the DatabaseName property for this object.
     */
    public String databaseName() {
        return databaseName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabase)) {
            return false;
        }
        RDSDatabase other = (RDSDatabase) obj;
        return Objects.equals(instanceIdentifier(), other.instanceIdentifier())
                && Objects.equals(databaseName(), other.databaseName());
    }

    @Override
    public String toString() {
        return ToString.builder("RDSDatabase").add("InstanceIdentifier", instanceIdentifier())
                .add("DatabaseName", databaseName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIdentifier":
            return Optional.ofNullable(clazz.cast(instanceIdentifier()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RDSDatabase> {
        /**
         * <p>
         * The ID of an RDS DB instance.
         * </p>
         * 
         * @param instanceIdentifier
         *        The ID of an RDS DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentifier(String instanceIdentifier);

        /**
         * Sets the value of the DatabaseName property for this object.
         *
         * @param databaseName
         *        The new value for the DatabaseName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);
    }

    static final class BuilderImpl implements Builder {
        private String instanceIdentifier;

        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabase model) {
            instanceIdentifier(model.instanceIdentifier);
            databaseName(model.databaseName);
        }

        public final String getInstanceIdentifier() {
            return instanceIdentifier;
        }

        @Override
        public final Builder instanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public final void setInstanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public RDSDatabase build() {
            return new RDSDatabase(this);
        }
    }
}
