/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateEvaluationRequestModelMarshaller {
    private static final MarshallingInfo<String> EVALUATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationId").isBinary(false).build();
    private static final MarshallingInfo<String> EVALUATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationName").isBinary(false).build();
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").isBinary(false).build();
    private static final MarshallingInfo<String> EVALUATIONDATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationDataSourceId").isBinary(false).build();
    private static final CreateEvaluationRequestModelMarshaller INSTANCE = new CreateEvaluationRequestModelMarshaller();

    private CreateEvaluationRequestModelMarshaller() {
    }

    public static CreateEvaluationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateEvaluationRequest createEvaluationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createEvaluationRequest), (String)"createEvaluationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createEvaluationRequest.evaluationId(), EVALUATIONID_BINDING);
            protocolMarshaller.marshall((Object)createEvaluationRequest.evaluationName(), EVALUATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)createEvaluationRequest.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall((Object)createEvaluationRequest.evaluationDataSourceId(), EVALUATIONDATASOURCEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

