/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.machinelearning.model.AddTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.AddTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRDSResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateMLModelResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteMLModelResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.GetMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.GetMLModelResponse;
import software.amazon.awssdk.services.machinelearning.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.machinelearning.model.InternalServerException;
import software.amazon.awssdk.services.machinelearning.model.InvalidInputException;
import software.amazon.awssdk.services.machinelearning.model.InvalidTagException;
import software.amazon.awssdk.services.machinelearning.model.LimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictResponse;
import software.amazon.awssdk.services.machinelearning.model.PredictorNotMountedException;
import software.amazon.awssdk.services.machinelearning.model.ResourceNotFoundException;
import software.amazon.awssdk.services.machinelearning.model.TagLimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateMLModelResponse;
import software.amazon.awssdk.services.machinelearning.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRDSRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRDSResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRedshiftRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRedshiftResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromS3RequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromS3ResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateMLModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateRealtimeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteMLModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteRealtimeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeBatchPredictionsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeBatchPredictionsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeDataSourcesResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeEvaluationsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeMLModelsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeMLModelsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetMLModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.PredictRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.PredictResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateMLModelResponseUnmarshaller;

/**
 * Internal implementation of {@link MachineLearningAsyncClient}.
 *
 * @see MachineLearningAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMachineLearningAsyncClient implements MachineLearningAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultMachineLearningAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams)
                .withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you
     * add a tag using a key that is already associated with the ML object, <code>AddTags</code> updates the tag's
     * value.
     * </p>
     * 
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidTagException</li>
     *         <li>TagLimitExceededException</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.AddTags
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {

        HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AddTagsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>()
                .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(addTagsRequest));
    }

    /**
     * <p>
     * Generates predictions for a group of observations. The observations to process exist in one or more data files
     * referenced by a <code>DataSource</code>. This operation creates a new <code>BatchPrediction</code>, and uses an
     * <code>MLModel</code> and the data files referenced by the <code>DataSource</code> as information sources.
     * </p>
     * <p>
     * <code>CreateBatchPrediction</code> is an asynchronous operation. In response to
     * <code>CreateBatchPrediction</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>BatchPrediction</code> status to <code>PENDING</code>. After the <code>BatchPrediction</code> completes,
     * Amazon ML sets the status to <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can poll for status updates by using the <a>GetBatchPrediction</a> operation and checking the
     * <code>Status</code> parameter of the result. After the <code>COMPLETED</code> status appears, the results are
     * available in the location specified by the <code>OutputUri</code> parameter.
     * </p>
     * 
     * @param createBatchPredictionRequest
     * @return A Java Future containing the result of the CreateBatchPrediction operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.CreateBatchPrediction
     */
    @Override
    public CompletableFuture<CreateBatchPredictionResponse> createBatchPrediction(
            CreateBatchPredictionRequest createBatchPredictionRequest) {

        HttpResponseHandler<CreateBatchPredictionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateBatchPredictionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateBatchPredictionRequest, CreateBatchPredictionResponse>()
                .withMarshaller(new CreateBatchPredictionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createBatchPredictionRequest));
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object from an <a href="http://aws.amazon.com/rds/"> Amazon Relational Database
     * Service</a> (Amazon RDS). A <code>DataSource</code> references data that can be used to perform
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromRDS</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromRDS</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready
     * for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in
     * the <code>COMPLETED</code> or <code>PENDING</code> state can be used only to perform
     * <code>&gt;CreateMLModel</code>&gt;, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code>
     * operations.
     * </p>
     * <p>
     * If Amazon ML cannot accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * 
     * @param createDataSourceFromRDSRequest
     * @return A Java Future containing the result of the CreateDataSourceFromRDS operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromRDS
     */
    @Override
    public CompletableFuture<CreateDataSourceFromRDSResponse> createDataSourceFromRDS(
            CreateDataSourceFromRDSRequest createDataSourceFromRDSRequest) {

        HttpResponseHandler<CreateDataSourceFromRDSResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDataSourceFromRDSResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDataSourceFromRDSRequest, CreateDataSourceFromRDSResponse>()
                .withMarshaller(new CreateDataSourceFromRDSRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDataSourceFromRDSRequest));
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> from a database hosted on an Amazon Redshift cluster. A <code>DataSource</code>
     * references data that can be used to perform either <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or
     * <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromRedshift</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromRedshift</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready
     * for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in
     * <code>COMPLETED</code> or <code>PENDING</code> states can be used to perform only <code>CreateMLModel</code>,
     * <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * <p>
     * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified
     * by a <code>SelectSqlQuery</code> query. Amazon ML executes an <code>Unload</code> command in Amazon Redshift to
     * transfer the result set of the <code>SelectSqlQuery</code> query to <code>S3StagingLocation</code>.
     * </p>
     * <p>
     * After the <code>DataSource</code> has been created, it's ready for use in evaluations and batch predictions. If
     * you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also
     * requires a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>.
     * Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it
     * be combined with another variable or will it be split apart into word combinations? The recipe provides answers
     * to these questions.
     * </p>
     * <?oxy_insert_start author="laurama" timestamp="20160406T153842-0700">
     * <p>
     * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon
     * Redshift datasource to create a new datasource. To do so, call <code>GetDataSource</code> for an existing
     * datasource and copy the values to a <code>CreateDataSource</code> call. Change the settings that you want to
     * change and make sure that all required fields have the appropriate values.
     * </p>
     * <?oxy_insert_end>
     * 
     * @param createDataSourceFromRedshiftRequest
     * @return A Java Future containing the result of the CreateDataSourceFromRedshift operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromRedshift
     */
    @Override
    public CompletableFuture<CreateDataSourceFromRedshiftResponse> createDataSourceFromRedshift(
            CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {

        HttpResponseHandler<CreateDataSourceFromRedshiftResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDataSourceFromRedshiftResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateDataSourceFromRedshiftRequest, CreateDataSourceFromRedshiftResponse>()
                        .withMarshaller(new CreateDataSourceFromRedshiftRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createDataSourceFromRedshiftRequest));
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object. A <code>DataSource</code> references data that can be used to perform
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromS3</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromS3</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> has been created and is
     * ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>.
     * <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can be used to perform only
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code> or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * <p>
     * The observation data used in a <code>DataSource</code> should be ready to use; that is, it should have a
     * consistent structure, and missing data values should be kept to a minimum. The observation data must reside in
     * one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that
     * describes the data items by name and type. The same schema must be used for all of the data files referenced by
     * the <code>DataSource</code>.
     * </p>
     * <p>
     * After the <code>DataSource</code> has been created, it's ready to use in evaluations and batch predictions. If
     * you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also
     * needs a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>. Will
     * the variable be included or excluded from training? Will the variable be manipulated; for example, will it be
     * combined with another variable or will it be split apart into word combinations? The recipe provides answers to
     * these questions.
     * </p>
     * 
     * @param createDataSourceFromS3Request
     * @return A Java Future containing the result of the CreateDataSourceFromS3 operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromS3
     */
    @Override
    public CompletableFuture<CreateDataSourceFromS3Response> createDataSourceFromS3(
            CreateDataSourceFromS3Request createDataSourceFromS3Request) {

        HttpResponseHandler<CreateDataSourceFromS3Response> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDataSourceFromS3ResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDataSourceFromS3Request, CreateDataSourceFromS3Response>()
                .withMarshaller(new CreateDataSourceFromS3RequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDataSourceFromS3Request));
    }

    /**
     * <p>
     * Creates a new <code>Evaluation</code> of an <code>MLModel</code>. An <code>MLModel</code> is evaluated on a set
     * of observations associated to a <code>DataSource</code>. Like a <code>DataSource</code> for an
     * <code>MLModel</code>, the <code>DataSource</code> for an <code>Evaluation</code> contains values for the
     * <code>Target Variable</code>. The <code>Evaluation</code> compares the predicted result for each observation to
     * the actual outcome and provides a summary so that you know how effective the <code>MLModel</code> functions on
     * the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or
     * MulticlassAvgFScore based on the corresponding <code>MLModelType</code>: <code>BINARY</code>,
     * <code>REGRESSION</code> or <code>MULTICLASS</code>.
     * </p>
     * <p>
     * <code>CreateEvaluation</code> is an asynchronous operation. In response to <code>CreateEvaluation</code>, Amazon
     * Machine Learning (Amazon ML) immediately returns and sets the evaluation status to <code>PENDING</code>. After
     * the <code>Evaluation</code> is created and ready for use, Amazon ML sets the status to <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can use the <code>GetEvaluation</code> operation to check progress of the evaluation during the creation
     * operation.
     * </p>
     * 
     * @param createEvaluationRequest
     * @return A Java Future containing the result of the CreateEvaluation operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.CreateEvaluation
     */
    @Override
    public CompletableFuture<CreateEvaluationResponse> createEvaluation(CreateEvaluationRequest createEvaluationRequest) {

        HttpResponseHandler<CreateEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateEvaluationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateEvaluationRequest, CreateEvaluationResponse>()
                .withMarshaller(new CreateEvaluationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createEvaluationRequest));
    }

    /**
     * <p>
     * Creates a new <code>MLModel</code> using the <code>DataSource</code> and the recipe as information sources.
     * </p>
     * <p>
     * An <code>MLModel</code> is nearly immutable. Users can update only the <code>MLModelName</code> and the
     * <code>ScoreThreshold</code> in an <code>MLModel</code> without creating a new <code>MLModel</code>.
     * </p>
     * <p>
     * <code>CreateMLModel</code> is an asynchronous operation. In response to <code>CreateMLModel</code>, Amazon
     * Machine Learning (Amazon ML) immediately returns and sets the <code>MLModel</code> status to <code>PENDING</code>
     * . After the <code>MLModel</code> has been created and ready is for use, Amazon ML sets the status to
     * <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can use the <code>GetMLModel</code> operation to check the progress of the <code>MLModel</code> during the
     * creation operation.
     * </p>
     * <p>
     * <code>CreateMLModel</code> requires a <code>DataSource</code> with computed statistics, which can be created by
     * setting <code>ComputeStatistics</code> to <code>true</code> in <code>CreateDataSourceFromRDS</code>,
     * <code>CreateDataSourceFromS3</code>, or <code>CreateDataSourceFromRedshift</code> operations.
     * </p>
     * 
     * @param createMLModelRequest
     * @return A Java Future containing the result of the CreateMLModel operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.CreateMLModel
     */
    @Override
    public CompletableFuture<CreateMLModelResponse> createMLModel(CreateMLModelRequest createMLModelRequest) {

        HttpResponseHandler<CreateMLModelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateMLModelResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateMLModelRequest, CreateMLModelResponse>()
                .withMarshaller(new CreateMLModelRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createMLModelRequest));
    }

    /**
     * <p>
     * Creates a real-time endpoint for the <code>MLModel</code>. The endpoint contains the URI of the
     * <code>MLModel</code>; that is, the location to send real-time prediction requests for the specified
     * <code>MLModel</code>.
     * </p>
     * 
     * @param createRealtimeEndpointRequest
     * @return A Java Future containing the result of the CreateRealtimeEndpoint operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.CreateRealtimeEndpoint
     */
    @Override
    public CompletableFuture<CreateRealtimeEndpointResponse> createRealtimeEndpoint(
            CreateRealtimeEndpointRequest createRealtimeEndpointRequest) {

        HttpResponseHandler<CreateRealtimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateRealtimeEndpointResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateRealtimeEndpointRequest, CreateRealtimeEndpointResponse>()
                .withMarshaller(new CreateRealtimeEndpointRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createRealtimeEndpointRequest));
    }

    /**
     * <p>
     * Assigns the DELETED status to a <code>BatchPrediction</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteBatchPrediction</code> operation, you can use the <a>GetBatchPrediction</a> operation
     * to verify that the status of the <code>BatchPrediction</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The result of the <code>DeleteBatchPrediction</code> operation is irreversible.
     * </p>
     * 
     * @param deleteBatchPredictionRequest
     * @return A Java Future containing the result of the DeleteBatchPrediction operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DeleteBatchPrediction
     */
    @Override
    public CompletableFuture<DeleteBatchPredictionResponse> deleteBatchPrediction(
            DeleteBatchPredictionRequest deleteBatchPredictionRequest) {

        HttpResponseHandler<DeleteBatchPredictionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteBatchPredictionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBatchPredictionRequest, DeleteBatchPredictionResponse>()
                .withMarshaller(new DeleteBatchPredictionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteBatchPredictionRequest));
    }

    /**
     * <p>
     * Assigns the DELETED status to a <code>DataSource</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteDataSource</code> operation, you can use the <a>GetDataSource</a> operation to verify
     * that the status of the <code>DataSource</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The results of the <code>DeleteDataSource</code> operation are irreversible.
     * </p>
     * 
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DeleteDataSource
     */
    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {

        HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDataSourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDataSourceRequest));
    }

    /**
     * <p>
     * Assigns the <code>DELETED</code> status to an <code>Evaluation</code>, rendering it unusable.
     * </p>
     * <p>
     * After invoking the <code>DeleteEvaluation</code> operation, you can use the <code>GetEvaluation</code> operation
     * to verify that the status of the <code>Evaluation</code> changed to <code>DELETED</code>.
     * </p>
     * <caution><title>Caution</title>
     * <p>
     * The results of the <code>DeleteEvaluation</code> operation are irreversible.
     * </p>
     * </caution>
     * 
     * @param deleteEvaluationRequest
     * @return A Java Future containing the result of the DeleteEvaluation operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DeleteEvaluation
     */
    @Override
    public CompletableFuture<DeleteEvaluationResponse> deleteEvaluation(DeleteEvaluationRequest deleteEvaluationRequest) {

        HttpResponseHandler<DeleteEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteEvaluationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteEvaluationRequest, DeleteEvaluationResponse>()
                .withMarshaller(new DeleteEvaluationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteEvaluationRequest));
    }

    /**
     * <p>
     * Assigns the <code>DELETED</code> status to an <code>MLModel</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteMLModel</code> operation, you can use the <code>GetMLModel</code> operation to verify
     * that the status of the <code>MLModel</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The result of the <code>DeleteMLModel</code> operation is irreversible.
     * </p>
     * 
     * @param deleteMLModelRequest
     * @return A Java Future containing the result of the DeleteMLModel operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DeleteMLModel
     */
    @Override
    public CompletableFuture<DeleteMLModelResponse> deleteMLModel(DeleteMLModelRequest deleteMLModelRequest) {

        HttpResponseHandler<DeleteMLModelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteMLModelResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteMLModelRequest, DeleteMLModelResponse>()
                .withMarshaller(new DeleteMLModelRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteMLModelRequest));
    }

    /**
     * <p>
     * Deletes a real time endpoint of an <code>MLModel</code>.
     * </p>
     * 
     * @param deleteRealtimeEndpointRequest
     * @return A Java Future containing the result of the DeleteRealtimeEndpoint operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DeleteRealtimeEndpoint
     */
    @Override
    public CompletableFuture<DeleteRealtimeEndpointResponse> deleteRealtimeEndpoint(
            DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest) {

        HttpResponseHandler<DeleteRealtimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteRealtimeEndpointResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteRealtimeEndpointRequest, DeleteRealtimeEndpointResponse>()
                .withMarshaller(new DeleteRealtimeEndpointRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteRealtimeEndpointRequest));
    }

    /**
     * <p>
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover
     * deleted tags.
     * </p>
     * <p>
     * If you specify a tag that doesn't exist, Amazon ML ignores it.
     * </p>
     * 
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidTagException</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DeleteTags
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {

        HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteTagsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>()
                .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteTagsRequest));
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     * 
     * @param describeBatchPredictionsRequest
     * @return A Java Future containing the result of the DescribeBatchPredictions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    @Override
    public CompletableFuture<DescribeBatchPredictionsResponse> describeBatchPredictions() {
        return describeBatchPredictions(DescribeBatchPredictionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     * 
     * @param describeBatchPredictionsRequest
     * @return A Java Future containing the result of the DescribeBatchPredictions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    @Override
    public CompletableFuture<DescribeBatchPredictionsResponse> describeBatchPredictions(
            DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {

        HttpResponseHandler<DescribeBatchPredictionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeBatchPredictionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResponse>()
                        .withMarshaller(new DescribeBatchPredictionsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeBatchPredictionsRequest));
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     * 
     * @param describeDataSourcesRequest
     * @return A Java Future containing the result of the DescribeDataSources operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    @Override
    public CompletableFuture<DescribeDataSourcesResponse> describeDataSources() {
        return describeDataSources(DescribeDataSourcesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     * 
     * @param describeDataSourcesRequest
     * @return A Java Future containing the result of the DescribeDataSources operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    @Override
    public CompletableFuture<DescribeDataSourcesResponse> describeDataSources(
            DescribeDataSourcesRequest describeDataSourcesRequest) {

        HttpResponseHandler<DescribeDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeDataSourcesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeDataSourcesRequest, DescribeDataSourcesResponse>()
                .withMarshaller(new DescribeDataSourcesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeDataSourcesRequest));
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     * 
     * @param describeEvaluationsRequest
     * @return A Java Future containing the result of the DescribeEvaluations operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    @Override
    public CompletableFuture<DescribeEvaluationsResponse> describeEvaluations() {
        return describeEvaluations(DescribeEvaluationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     * 
     * @param describeEvaluationsRequest
     * @return A Java Future containing the result of the DescribeEvaluations operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    @Override
    public CompletableFuture<DescribeEvaluationsResponse> describeEvaluations(
            DescribeEvaluationsRequest describeEvaluationsRequest) {

        HttpResponseHandler<DescribeEvaluationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeEvaluationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeEvaluationsRequest, DescribeEvaluationsResponse>()
                .withMarshaller(new DescribeEvaluationsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeEvaluationsRequest));
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     * 
     * @param describeMLModelsRequest
     * @return A Java Future containing the result of the DescribeMLModels operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    @Override
    public CompletableFuture<DescribeMLModelsResponse> describeMLModels() {
        return describeMLModels(DescribeMLModelsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     * 
     * @param describeMLModelsRequest
     * @return A Java Future containing the result of the DescribeMLModels operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    @Override
    public CompletableFuture<DescribeMLModelsResponse> describeMLModels(DescribeMLModelsRequest describeMLModelsRequest) {

        HttpResponseHandler<DescribeMLModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeMLModelsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeMLModelsRequest, DescribeMLModelsResponse>()
                .withMarshaller(new DescribeMLModelsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeMLModelsRequest));
    }

    /**
     * <p>
     * Describes one or more of the tags for your Amazon ML object.
     * </p>
     * 
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.DescribeTags
     */
    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {

        HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeTagsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeTagsRequest));
    }

    /**
     * <p>
     * Returns a <code>BatchPrediction</code> that includes detailed metadata, status, and data file information for a
     * <code>Batch Prediction</code> request.
     * </p>
     * 
     * @param getBatchPredictionRequest
     * @return A Java Future containing the result of the GetBatchPrediction operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.GetBatchPrediction
     */
    @Override
    public CompletableFuture<GetBatchPredictionResponse> getBatchPrediction(GetBatchPredictionRequest getBatchPredictionRequest) {

        HttpResponseHandler<GetBatchPredictionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetBatchPredictionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBatchPredictionRequest, GetBatchPredictionResponse>()
                .withMarshaller(new GetBatchPredictionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBatchPredictionRequest));
    }

    /**
     * <p>
     * Returns a <code>DataSource</code> that includes metadata and data file information, as well as the current status
     * of the <code>DataSource</code>.
     * </p>
     * <p>
     * <code>GetDataSource</code> provides results in normal or verbose format. The verbose format adds the schema
     * description and the list of files pointed to by the DataSource to the normal format.
     * </p>
     * 
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.GetDataSource
     */
    @Override
    public CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {

        HttpResponseHandler<GetDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDataSourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDataSourceRequest, GetDataSourceResponse>()
                .withMarshaller(new GetDataSourceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDataSourceRequest));
    }

    /**
     * <p>
     * Returns an <code>Evaluation</code> that includes metadata as well as the current status of the
     * <code>Evaluation</code>.
     * </p>
     * 
     * @param getEvaluationRequest
     * @return A Java Future containing the result of the GetEvaluation operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.GetEvaluation
     */
    @Override
    public CompletableFuture<GetEvaluationResponse> getEvaluation(GetEvaluationRequest getEvaluationRequest) {

        HttpResponseHandler<GetEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetEvaluationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetEvaluationRequest, GetEvaluationResponse>()
                .withMarshaller(new GetEvaluationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getEvaluationRequest));
    }

    /**
     * <p>
     * Returns an <code>MLModel</code> that includes detailed metadata, data source information, and the current status
     * of the <code>MLModel</code>.
     * </p>
     * <p>
     * <code>GetMLModel</code> provides results in normal or verbose format.
     * </p>
     * 
     * @param getMLModelRequest
     * @return A Java Future containing the result of the GetMLModel operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.GetMLModel
     */
    @Override
    public CompletableFuture<GetMLModelResponse> getMLModel(GetMLModelRequest getMLModelRequest) {

        HttpResponseHandler<GetMLModelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetMLModelResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetMLModelRequest, GetMLModelResponse>()
                .withMarshaller(new GetMLModelRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMLModelRequest));
    }

    /**
     * <p>
     * Generates a prediction for the observation using the specified <code>ML Model</code>.
     * </p>
     * <note><title>Note</title>
     * <p>
     * Not all response parameters will be populated. Whether a response parameter is populated depends on the type of
     * model requested.
     * </p>
     * </note>
     * 
     * @param predictRequest
     * @return A Java Future containing the result of the Predict operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>LimitExceededException The subscriber exceeded the maximum number of operations. This exception can
     *         occur when listing objects such as <code>DataSource</code>.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>PredictorNotMountedException The exception is thrown when a predict request is made to an unmounted
     *         <code>MLModel</code>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.Predict
     */
    @Override
    public CompletableFuture<PredictResponse> predict(PredictRequest predictRequest) {

        HttpResponseHandler<PredictResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new PredictResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PredictRequest, PredictResponse>()
                .withMarshaller(new PredictRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(predictRequest));
    }

    /**
     * <p>
     * Updates the <code>BatchPredictionName</code> of a <code>BatchPrediction</code>.
     * </p>
     * <p>
     * You can use the <code>GetBatchPrediction</code> operation to view the contents of the updated data element.
     * </p>
     * 
     * @param updateBatchPredictionRequest
     * @return A Java Future containing the result of the UpdateBatchPrediction operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.UpdateBatchPrediction
     */
    @Override
    public CompletableFuture<UpdateBatchPredictionResponse> updateBatchPrediction(
            UpdateBatchPredictionRequest updateBatchPredictionRequest) {

        HttpResponseHandler<UpdateBatchPredictionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateBatchPredictionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateBatchPredictionRequest, UpdateBatchPredictionResponse>()
                .withMarshaller(new UpdateBatchPredictionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateBatchPredictionRequest));
    }

    /**
     * <p>
     * Updates the <code>DataSourceName</code> of a <code>DataSource</code>.
     * </p>
     * <p>
     * You can use the <code>GetDataSource</code> operation to view the contents of the updated data element.
     * </p>
     * 
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.UpdateDataSource
     */
    @Override
    public CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {

        HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateDataSourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDataSourceRequest));
    }

    /**
     * <p>
     * Updates the <code>EvaluationName</code> of an <code>Evaluation</code>.
     * </p>
     * <p>
     * You can use the <code>GetEvaluation</code> operation to view the contents of the updated data element.
     * </p>
     * 
     * @param updateEvaluationRequest
     * @return A Java Future containing the result of the UpdateEvaluation operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.UpdateEvaluation
     */
    @Override
    public CompletableFuture<UpdateEvaluationResponse> updateEvaluation(UpdateEvaluationRequest updateEvaluationRequest) {

        HttpResponseHandler<UpdateEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateEvaluationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateEvaluationRequest, UpdateEvaluationResponse>()
                .withMarshaller(new UpdateEvaluationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateEvaluationRequest));
    }

    /**
     * <p>
     * Updates the <code>MLModelName</code> and the <code>ScoreThreshold</code> of an <code>MLModel</code>.
     * </p>
     * <p>
     * You can use the <code>GetMLModel</code> operation to view the contents of the updated data element.
     * </p>
     * 
     * @param updateMLModelRequest
     * @return A Java Future containing the result of the UpdateMLModel operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this</li >
     *         <ul>
     * @sample MachineLearningAsyncClient.UpdateMLModel
     */
    @Override
    public CompletableFuture<UpdateMLModelResponse> updateMLModel(UpdateMLModelRequest updateMLModelRequest) {

        HttpResponseHandler<UpdateMLModelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateMLModelResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateMLModelRequest, UpdateMLModelResponse>()
                .withMarshaller(new UpdateMLModelRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateMLModelRequest));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata()
                .withProtocolVersion("1.1")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(
                        software.amazon.awssdk.services.machinelearning.model.MachineLearningException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTagException").withModeledClass(
                                InvalidTagException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(
                                ResourceNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(
                                InvalidInputException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatchException").withModeledClass(
                                IdempotentParameterMismatchException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TagLimitExceededException").withModeledClass(
                                TagLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(
                                InternalServerException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                LimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("PredictorNotMountedException").withModeledClass(
                                PredictorNotMountedException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
