/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.BatchPredictionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetBatchPrediction</code> operation.
 * </p>
 * <p>
 * The content consists of the detailed metadata, the status, and the data file information of a
 * <code>Batch Prediction</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchPrediction implements StructuredPojo, ToCopyableBuilder<BatchPrediction.Builder, BatchPrediction> {
    private final String batchPredictionId;

    private final String mlModelId;

    private final String batchPredictionDataSourceId;

    private final String inputDataLocationS3;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String status;

    private final String outputUri;

    private final String message;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private final Long totalRecordCount;

    private final Long invalidRecordCount;

    private BatchPrediction(BuilderImpl builder) {
        this.batchPredictionId = builder.batchPredictionId;
        this.mlModelId = builder.mlModelId;
        this.batchPredictionDataSourceId = builder.batchPredictionDataSourceId;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.outputUri = builder.outputUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.totalRecordCount = builder.totalRecordCount;
        this.invalidRecordCount = builder.invalidRecordCount;
    }

    /**
     * <p>
     * The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of
     * the <code>BatchPredictionID</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the
     *         value of the <code>BatchPredictionID</code> in the request.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    /**
     * <p>
     * The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.
     * </p>
     * 
     * @return The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code>
     *         request.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the <code>DataSource</code> that points to the group of observations to predict.
     * </p>
     * 
     * @return The ID of the <code>DataSource</code> that points to the group of observations to predict.
     */
    public String batchPredictionDataSourceId() {
        return batchPredictionDataSourceId;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public String inputDataLocationS3() {
        return inputDataLocationS3;
    }

    /**
     * <p>
     * The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root
     * account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS
     *         root account or an AWS Identity and Access Management (IAM) user account.
     */
    public String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch
     *         time.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>BatchPrediction</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>BatchPrediction</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status of the <code>BatchPrediction</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions for a
     * batch of observations.</li>
     * <li> <code>INPROGRESS</code> - The process is underway.</li>
     * <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</li>
     * <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * 
     * @return The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate
     *         predictions for a batch of observations.</li>
     *         <li> <code>INPROGRESS</code> - The process is underway.</li>
     *         <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not
     *         usable.</li>
     *         <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The location of an Amazon S3 bucket or directory to receive the operation results. The following substrings are
     * not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.
     * </p>
     * 
     * @return The location of an Amazon S3 bucket or directory to receive the operation results. The following
     *         substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':',
     *         '//', '/./', '/../'.
     */
    public String outputUri() {
        return outputUri;
    }

    /**
     * <p>
     * A description of the most recent details about processing the batch prediction request.
     * </p>
     * 
     * @return A description of the most recent details about processing the batch prediction request.
     */
    public String message() {
        return message;
    }

    /**
     * Returns the value of the ComputeTime property for this object.
     * 
     * @return The value of the ComputeTime property for this object.
     */
    public Long computeTime() {
        return computeTime;
    }

    /**
     * Returns the value of the FinishedAt property for this object.
     * 
     * @return The value of the FinishedAt property for this object.
     */
    public Instant finishedAt() {
        return finishedAt;
    }

    /**
     * Returns the value of the StartedAt property for this object.
     * 
     * @return The value of the StartedAt property for this object.
     */
    public Instant startedAt() {
        return startedAt;
    }

    /**
     * Returns the value of the TotalRecordCount property for this object.
     * 
     * @return The value of the TotalRecordCount property for this object.
     */
    public Long totalRecordCount() {
        return totalRecordCount;
    }

    /**
     * Returns the value of the InvalidRecordCount property for this object.
     * 
     * @return The value of the InvalidRecordCount property for this object.
     */
    public Long invalidRecordCount() {
        return invalidRecordCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((batchPredictionId() == null) ? 0 : batchPredictionId().hashCode());
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((batchPredictionDataSourceId() == null) ? 0 : batchPredictionDataSourceId().hashCode());
        hashCode = 31 * hashCode + ((inputDataLocationS3() == null) ? 0 : inputDataLocationS3().hashCode());
        hashCode = 31 * hashCode + ((createdByIamUser() == null) ? 0 : createdByIamUser().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedAt() == null) ? 0 : lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((outputUri() == null) ? 0 : outputUri().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((computeTime() == null) ? 0 : computeTime().hashCode());
        hashCode = 31 * hashCode + ((finishedAt() == null) ? 0 : finishedAt().hashCode());
        hashCode = 31 * hashCode + ((startedAt() == null) ? 0 : startedAt().hashCode());
        hashCode = 31 * hashCode + ((totalRecordCount() == null) ? 0 : totalRecordCount().hashCode());
        hashCode = 31 * hashCode + ((invalidRecordCount() == null) ? 0 : invalidRecordCount().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPrediction)) {
            return false;
        }
        BatchPrediction other = (BatchPrediction) obj;
        if (other.batchPredictionId() == null ^ this.batchPredictionId() == null) {
            return false;
        }
        if (other.batchPredictionId() != null && !other.batchPredictionId().equals(this.batchPredictionId())) {
            return false;
        }
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.batchPredictionDataSourceId() == null ^ this.batchPredictionDataSourceId() == null) {
            return false;
        }
        if (other.batchPredictionDataSourceId() != null
                && !other.batchPredictionDataSourceId().equals(this.batchPredictionDataSourceId())) {
            return false;
        }
        if (other.inputDataLocationS3() == null ^ this.inputDataLocationS3() == null) {
            return false;
        }
        if (other.inputDataLocationS3() != null && !other.inputDataLocationS3().equals(this.inputDataLocationS3())) {
            return false;
        }
        if (other.createdByIamUser() == null ^ this.createdByIamUser() == null) {
            return false;
        }
        if (other.createdByIamUser() != null && !other.createdByIamUser().equals(this.createdByIamUser())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.outputUri() == null ^ this.outputUri() == null) {
            return false;
        }
        if (other.outputUri() != null && !other.outputUri().equals(this.outputUri())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.computeTime() == null ^ this.computeTime() == null) {
            return false;
        }
        if (other.computeTime() != null && !other.computeTime().equals(this.computeTime())) {
            return false;
        }
        if (other.finishedAt() == null ^ this.finishedAt() == null) {
            return false;
        }
        if (other.finishedAt() != null && !other.finishedAt().equals(this.finishedAt())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        if (other.totalRecordCount() == null ^ this.totalRecordCount() == null) {
            return false;
        }
        if (other.totalRecordCount() != null && !other.totalRecordCount().equals(this.totalRecordCount())) {
            return false;
        }
        if (other.invalidRecordCount() == null ^ this.invalidRecordCount() == null) {
            return false;
        }
        if (other.invalidRecordCount() != null && !other.invalidRecordCount().equals(this.invalidRecordCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (batchPredictionId() != null) {
            sb.append("BatchPredictionId: ").append(batchPredictionId()).append(",");
        }
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (batchPredictionDataSourceId() != null) {
            sb.append("BatchPredictionDataSourceId: ").append(batchPredictionDataSourceId()).append(",");
        }
        if (inputDataLocationS3() != null) {
            sb.append("InputDataLocationS3: ").append(inputDataLocationS3()).append(",");
        }
        if (createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(createdByIamUser()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(lastUpdatedAt()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (outputUri() != null) {
            sb.append("OutputUri: ").append(outputUri()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (computeTime() != null) {
            sb.append("ComputeTime: ").append(computeTime()).append(",");
        }
        if (finishedAt() != null) {
            sb.append("FinishedAt: ").append(finishedAt()).append(",");
        }
        if (startedAt() != null) {
            sb.append("StartedAt: ").append(startedAt()).append(",");
        }
        if (totalRecordCount() != null) {
            sb.append("TotalRecordCount: ").append(totalRecordCount()).append(",");
        }
        if (invalidRecordCount() != null) {
            sb.append("InvalidRecordCount: ").append(invalidRecordCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchPredictionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BatchPrediction> {
        /**
         * <p>
         * The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value
         * of the <code>BatchPredictionID</code> in the request.
         * </p>
         * 
         * @param batchPredictionId
         *        The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the
         *        value of the <code>BatchPredictionID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);

        /**
         * <p>
         * The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.
         * </p>
         * 
         * @param mlModelId
         *        The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the <code>DataSource</code> that points to the group of observations to predict.
         * </p>
         * 
         * @param batchPredictionDataSourceId
         *        The ID of the <code>DataSource</code> that points to the group of observations to predict.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionDataSourceId(String batchPredictionDataSourceId);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param inputDataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataLocationS3(String inputDataLocationS3);

        /**
         * <p>
         * The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS
         * root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an
         *        AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A user-supplied name or description of the <code>BatchPrediction</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>BatchPrediction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the <code>BatchPrediction</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions
         * for a batch of observations.</li>
         * <li> <code>INPROGRESS</code> - The process is underway.</li>
         * <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not
         * usable.</li>
         * <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate
         *        predictions for a batch of observations.</li>
         *        <li> <code>INPROGRESS</code> - The process is underway.</li>
         *        <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is
         *        not usable.</li>
         *        <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the <code>BatchPrediction</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions
         * for a batch of observations.</li>
         * <li> <code>INPROGRESS</code> - The process is underway.</li>
         * <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not
         * usable.</li>
         * <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate
         *        predictions for a batch of observations.</li>
         *        <li> <code>INPROGRESS</code> - The process is underway.</li>
         *        <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is
         *        not usable.</li>
         *        <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * <p>
         * The location of an Amazon S3 bucket or directory to receive the operation results. The following substrings
         * are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./',
         * '/../'.
         * </p>
         * 
         * @param outputUri
         *        The location of an Amazon S3 bucket or directory to receive the operation results. The following
         *        substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field:
         *        ':', '//', '/./', '/../'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUri(String outputUri);

        /**
         * <p>
         * A description of the most recent details about processing the batch prediction request.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about processing the batch prediction request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * Sets the value of the ComputeTime property for this object.
         *
         * @param computeTime
         *        The new value for the ComputeTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * Sets the value of the FinishedAt property for this object.
         *
         * @param finishedAt
         *        The new value for the FinishedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * Sets the value of the StartedAt property for this object.
         *
         * @param startedAt
         *        The new value for the StartedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * Sets the value of the TotalRecordCount property for this object.
         *
         * @param totalRecordCount
         *        The new value for the TotalRecordCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecordCount(Long totalRecordCount);

        /**
         * Sets the value of the InvalidRecordCount property for this object.
         *
         * @param invalidRecordCount
         *        The new value for the InvalidRecordCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidRecordCount(Long invalidRecordCount);
    }

    private static final class BuilderImpl implements Builder {
        private String batchPredictionId;

        private String mlModelId;

        private String batchPredictionDataSourceId;

        private String inputDataLocationS3;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String name;

        private String status;

        private String outputUri;

        private String message;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private Long totalRecordCount;

        private Long invalidRecordCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPrediction model) {
            setBatchPredictionId(model.batchPredictionId);
            setMLModelId(model.mlModelId);
            setBatchPredictionDataSourceId(model.batchPredictionDataSourceId);
            setInputDataLocationS3(model.inputDataLocationS3);
            setCreatedByIamUser(model.createdByIamUser);
            setCreatedAt(model.createdAt);
            setLastUpdatedAt(model.lastUpdatedAt);
            setName(model.name);
            setStatus(model.status);
            setOutputUri(model.outputUri);
            setMessage(model.message);
            setComputeTime(model.computeTime);
            setFinishedAt(model.finishedAt);
            setStartedAt(model.startedAt);
            setTotalRecordCount(model.totalRecordCount);
            setInvalidRecordCount(model.invalidRecordCount);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getBatchPredictionDataSourceId() {
            return batchPredictionDataSourceId;
        }

        @Override
        public final Builder batchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
            return this;
        }

        public final void setBatchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
        }

        public final String getInputDataLocationS3() {
            return inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(EntityStatus status) {
            this.status(status.toString());
        }

        public final String getOutputUri() {
            return outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getTotalRecordCount() {
            return totalRecordCount;
        }

        @Override
        public final Builder totalRecordCount(Long totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
            return this;
        }

        public final void setTotalRecordCount(Long totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
        }

        public final Long getInvalidRecordCount() {
            return invalidRecordCount;
        }

        @Override
        public final Builder invalidRecordCount(Long invalidRecordCount) {
            this.invalidRecordCount = invalidRecordCount;
            return this;
        }

        public final void setInvalidRecordCount(Long invalidRecordCount) {
            this.invalidRecordCount = invalidRecordCount;
        }

        @Override
        public BatchPrediction build() {
            return new BatchPrediction(this);
        }
    }
}
