/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateEvaluation</code> operation, and is an acknowledgement that Amazon ML received
 * the request.
 * </p>
 * <p>
 * <code>CreateEvaluation</code> operation is asynchronous. You can poll for status updates by using the
 * <code>GetEvcaluation</code> operation and checking the <code>Status</code> parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateEvaluationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateEvaluationResponse.Builder, CreateEvaluationResponse> {
    private final String evaluationId;

    private CreateEvaluationResponse(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
    }

    /**
     * <p>
     * The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the
     * value of the <code>EvaluationId</code> in the request.
     * </p>
     * 
     * @return The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical
     *         to the value of the <code>EvaluationId</code> in the request.
     */
    public String evaluationId() {
        return evaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((evaluationId() == null) ? 0 : evaluationId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationResponse)) {
            return false;
        }
        CreateEvaluationResponse other = (CreateEvaluationResponse) obj;
        if (other.evaluationId() == null ^ this.evaluationId() == null) {
            return false;
        }
        if (other.evaluationId() != null && !other.evaluationId().equals(this.evaluationId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (evaluationId() != null) {
            sb.append("EvaluationId: ").append(evaluationId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateEvaluationResponse> {
        /**
         * <p>
         * The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to
         * the value of the <code>EvaluationId</code> in the request.
         * </p>
         * 
         * @param evaluationId
         *        The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be
         *        identical to the value of the <code>EvaluationId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);
    }

    private static final class BuilderImpl implements Builder {
        private String evaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationResponse model) {
            setEvaluationId(model.evaluationId);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public CreateEvaluationResponse build() {
            return new CreateEvaluationResponse(this);
        }
    }
}
