/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.DataSourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of the <code>GetDataSource</code> operation.
 * </p>
 * <p>
 * The content consists of the detailed metadata and data file information and the current status of the
 * <code>DataSource</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DataSource implements StructuredPojo, ToCopyableBuilder<DataSource.Builder, DataSource> {
    private final String dataSourceId;

    private final String dataLocationS3;

    private final String dataRearrangement;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Long dataSizeInBytes;

    private final Long numberOfFiles;

    private final String name;

    private final String status;

    private final String message;

    private final RedshiftMetadata redshiftMetadata;

    private final RDSMetadata rdsMetadata;

    private final String roleARN;

    private final Boolean computeStatistics;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private DataSource(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataLocationS3 = builder.dataLocationS3;
        this.dataRearrangement = builder.dataRearrangement;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.dataSizeInBytes = builder.dataSizeInBytes;
        this.numberOfFiles = builder.numberOfFiles;
        this.name = builder.name;
        this.status = builder.status;
        this.message = builder.message;
        this.redshiftMetadata = builder.redshiftMetadata;
        this.rdsMetadata = builder.rdsMetadata;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
    }

    /**
     * <p>
     * The ID that is assigned to the <code>DataSource</code> during creation.
     * </p>
     * 
     * @return The ID that is assigned to the <code>DataSource</code> during creation.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The location and name of the data in Amazon Simple Storage Service (Amazon S3) that is used by a
     * <code>DataSource</code>.
     * </p>
     * 
     * @return The location and name of the data in Amazon Simple Storage Service (Amazon S3) that is used by a
     *         <code>DataSource</code>.
     */
    public String dataLocationS3() {
        return dataLocationS3;
    }

    /**
     * <p>
     * A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code>
     * was created.
     * </p>
     * 
     * @return A JSON string that represents the splitting and rearrangement requirement used when this
     *         <code>DataSource</code> was created.
     */
    public String dataRearrangement() {
        return dataRearrangement;
    }

    /**
     * <p>
     * The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS
     * root account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account from which the <code>DataSource</code> was created. The account type can be either
     *         an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch
     *         time.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The total number of observations contained in the data files that the <code>DataSource</code> references.
     * </p>
     * 
     * @return The total number of observations contained in the data files that the <code>DataSource</code> references.
     */
    public Long dataSizeInBytes() {
        return dataSizeInBytes;
    }

    /**
     * <p>
     * The number of data files referenced by the <code>DataSource</code>.
     * </p>
     * 
     * @return The number of data files referenced by the <code>DataSource</code>.
     */
    public Long numberOfFiles() {
        return numberOfFiles;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>DataSource</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the <code>DataSource</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li>PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create a <code>DataSource</code>.</li>
     * <li>INPROGRESS - The creation process is underway.</li>
     * <li>FAILED - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</li>
     * <li>COMPLETED - The creation process completed successfully.</li>
     * <li>DELETED - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * 
     * @return The current status of the <code>DataSource</code>. This element can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create a <code>DataSource</code>
     *         .</li>
     *         <li>INPROGRESS - The creation process is underway.</li>
     *         <li>FAILED - The request to create a <code>DataSource</code> did not run to completion. It is not usable.
     *         </li>
     *         <li>COMPLETED - The creation process completed successfully.</li>
     *         <li>DELETED - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A description of the most recent details about creating the <code>DataSource</code>.
     * </p>
     * 
     * @return A description of the most recent details about creating the <code>DataSource</code>.
     */
    public String message() {
        return message;
    }

    /**
     * Returns the value of the RedshiftMetadata property for this object.
     * 
     * @return The value of the RedshiftMetadata property for this object.
     */
    public RedshiftMetadata redshiftMetadata() {
        return redshiftMetadata;
    }

    /**
     * Returns the value of the RDSMetadata property for this object.
     * 
     * @return The value of the RDSMetadata property for this object.
     */
    public RDSMetadata rdsMetadata() {
        return rdsMetadata;
    }

    /**
     * Returns the value of the RoleARN property for this object.
     * 
     * @return The value of the RoleARN property for this object.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The parameter is <code>true</code> if statistics need to be generated from the observation data.
     * </p>
     * 
     * @return The parameter is <code>true</code> if statistics need to be generated from the observation data.
     */
    public Boolean computeStatistics() {
        return computeStatistics;
    }

    /**
     * Returns the value of the ComputeTime property for this object.
     * 
     * @return The value of the ComputeTime property for this object.
     */
    public Long computeTime() {
        return computeTime;
    }

    /**
     * Returns the value of the FinishedAt property for this object.
     * 
     * @return The value of the FinishedAt property for this object.
     */
    public Instant finishedAt() {
        return finishedAt;
    }

    /**
     * Returns the value of the StartedAt property for this object.
     * 
     * @return The value of the StartedAt property for this object.
     */
    public Instant startedAt() {
        return startedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataSourceId() == null) ? 0 : dataSourceId().hashCode());
        hashCode = 31 * hashCode + ((dataLocationS3() == null) ? 0 : dataLocationS3().hashCode());
        hashCode = 31 * hashCode + ((dataRearrangement() == null) ? 0 : dataRearrangement().hashCode());
        hashCode = 31 * hashCode + ((createdByIamUser() == null) ? 0 : createdByIamUser().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedAt() == null) ? 0 : lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((dataSizeInBytes() == null) ? 0 : dataSizeInBytes().hashCode());
        hashCode = 31 * hashCode + ((numberOfFiles() == null) ? 0 : numberOfFiles().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((redshiftMetadata() == null) ? 0 : redshiftMetadata().hashCode());
        hashCode = 31 * hashCode + ((rdsMetadata() == null) ? 0 : rdsMetadata().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((computeStatistics() == null) ? 0 : computeStatistics().hashCode());
        hashCode = 31 * hashCode + ((computeTime() == null) ? 0 : computeTime().hashCode());
        hashCode = 31 * hashCode + ((finishedAt() == null) ? 0 : finishedAt().hashCode());
        hashCode = 31 * hashCode + ((startedAt() == null) ? 0 : startedAt().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource) obj;
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataLocationS3() == null ^ this.dataLocationS3() == null) {
            return false;
        }
        if (other.dataLocationS3() != null && !other.dataLocationS3().equals(this.dataLocationS3())) {
            return false;
        }
        if (other.dataRearrangement() == null ^ this.dataRearrangement() == null) {
            return false;
        }
        if (other.dataRearrangement() != null && !other.dataRearrangement().equals(this.dataRearrangement())) {
            return false;
        }
        if (other.createdByIamUser() == null ^ this.createdByIamUser() == null) {
            return false;
        }
        if (other.createdByIamUser() != null && !other.createdByIamUser().equals(this.createdByIamUser())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.dataSizeInBytes() == null ^ this.dataSizeInBytes() == null) {
            return false;
        }
        if (other.dataSizeInBytes() != null && !other.dataSizeInBytes().equals(this.dataSizeInBytes())) {
            return false;
        }
        if (other.numberOfFiles() == null ^ this.numberOfFiles() == null) {
            return false;
        }
        if (other.numberOfFiles() != null && !other.numberOfFiles().equals(this.numberOfFiles())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.redshiftMetadata() == null ^ this.redshiftMetadata() == null) {
            return false;
        }
        if (other.redshiftMetadata() != null && !other.redshiftMetadata().equals(this.redshiftMetadata())) {
            return false;
        }
        if (other.rdsMetadata() == null ^ this.rdsMetadata() == null) {
            return false;
        }
        if (other.rdsMetadata() != null && !other.rdsMetadata().equals(this.rdsMetadata())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.computeStatistics() == null ^ this.computeStatistics() == null) {
            return false;
        }
        if (other.computeStatistics() != null && !other.computeStatistics().equals(this.computeStatistics())) {
            return false;
        }
        if (other.computeTime() == null ^ this.computeTime() == null) {
            return false;
        }
        if (other.computeTime() != null && !other.computeTime().equals(this.computeTime())) {
            return false;
        }
        if (other.finishedAt() == null ^ this.finishedAt() == null) {
            return false;
        }
        if (other.finishedAt() != null && !other.finishedAt().equals(this.finishedAt())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dataSourceId() != null) {
            sb.append("DataSourceId: ").append(dataSourceId()).append(",");
        }
        if (dataLocationS3() != null) {
            sb.append("DataLocationS3: ").append(dataLocationS3()).append(",");
        }
        if (dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(dataRearrangement()).append(",");
        }
        if (createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(createdByIamUser()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(lastUpdatedAt()).append(",");
        }
        if (dataSizeInBytes() != null) {
            sb.append("DataSizeInBytes: ").append(dataSizeInBytes()).append(",");
        }
        if (numberOfFiles() != null) {
            sb.append("NumberOfFiles: ").append(numberOfFiles()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (redshiftMetadata() != null) {
            sb.append("RedshiftMetadata: ").append(redshiftMetadata()).append(",");
        }
        if (rdsMetadata() != null) {
            sb.append("RDSMetadata: ").append(rdsMetadata()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(computeStatistics()).append(",");
        }
        if (computeTime() != null) {
            sb.append("ComputeTime: ").append(computeTime()).append(",");
        }
        if (finishedAt() != null) {
            sb.append("FinishedAt: ").append(finishedAt()).append(",");
        }
        if (startedAt() != null) {
            sb.append("StartedAt: ").append(startedAt()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DataSource> {
        /**
         * <p>
         * The ID that is assigned to the <code>DataSource</code> during creation.
         * </p>
         * 
         * @param dataSourceId
         *        The ID that is assigned to the <code>DataSource</code> during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The location and name of the data in Amazon Simple Storage Service (Amazon S3) that is used by a
         * <code>DataSource</code>.
         * </p>
         * 
         * @param dataLocationS3
         *        The location and name of the data in Amazon Simple Storage Service (Amazon S3) that is used by a
         *        <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocationS3(String dataLocationS3);

        /**
         * <p>
         * A JSON string that represents the splitting and rearrangement requirement used when this
         * <code>DataSource</code> was created.
         * </p>
         * 
         * @param dataRearrangement
         *        A JSON string that represents the splitting and rearrangement requirement used when this
         *        <code>DataSource</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRearrangement(String dataRearrangement);

        /**
         * <p>
         * The AWS user account from which the <code>DataSource</code> was created. The account type can be either an
         * AWS root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account from which the <code>DataSource</code> was created. The account type can be
         *        either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The total number of observations contained in the data files that the <code>DataSource</code> references.
         * </p>
         * 
         * @param dataSizeInBytes
         *        The total number of observations contained in the data files that the <code>DataSource</code>
         *        references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSizeInBytes(Long dataSizeInBytes);

        /**
         * <p>
         * The number of data files referenced by the <code>DataSource</code>.
         * </p>
         * 
         * @param numberOfFiles
         *        The number of data files referenced by the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFiles(Long numberOfFiles);

        /**
         * <p>
         * A user-supplied name or description of the <code>DataSource</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the <code>DataSource</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li>PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create a <code>DataSource</code>.</li>
         * <li>INPROGRESS - The creation process is underway.</li>
         * <li>FAILED - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</li>
         * <li>COMPLETED - The creation process completed successfully.</li>
         * <li>DELETED - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>DataSource</code>. This element can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create a
         *        <code>DataSource</code>.</li>
         *        <li>INPROGRESS - The creation process is underway.</li>
         *        <li>FAILED - The request to create a <code>DataSource</code> did not run to completion. It is not
         *        usable.</li>
         *        <li>COMPLETED - The creation process completed successfully.</li>
         *        <li>DELETED - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the <code>DataSource</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li>PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create a <code>DataSource</code>.</li>
         * <li>INPROGRESS - The creation process is underway.</li>
         * <li>FAILED - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</li>
         * <li>COMPLETED - The creation process completed successfully.</li>
         * <li>DELETED - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>DataSource</code>. This element can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create a
         *        <code>DataSource</code>.</li>
         *        <li>INPROGRESS - The creation process is underway.</li>
         *        <li>FAILED - The request to create a <code>DataSource</code> did not run to completion. It is not
         *        usable.</li>
         *        <li>COMPLETED - The creation process completed successfully.</li>
         *        <li>DELETED - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * <p>
         * A description of the most recent details about creating the <code>DataSource</code>.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about creating the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * Sets the value of the RedshiftMetadata property for this object.
         *
         * @param redshiftMetadata
         *        The new value for the RedshiftMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftMetadata(RedshiftMetadata redshiftMetadata);

        /**
         * Sets the value of the RDSMetadata property for this object.
         *
         * @param rdsMetadata
         *        The new value for the RDSMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsMetadata(RDSMetadata rdsMetadata);

        /**
         * Sets the value of the RoleARN property for this object.
         *
         * @param roleARN
         *        The new value for the RoleARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The parameter is <code>true</code> if statistics need to be generated from the observation data.
         * </p>
         * 
         * @param computeStatistics
         *        The parameter is <code>true</code> if statistics need to be generated from the observation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeStatistics(Boolean computeStatistics);

        /**
         * Sets the value of the ComputeTime property for this object.
         *
         * @param computeTime
         *        The new value for the ComputeTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * Sets the value of the FinishedAt property for this object.
         *
         * @param finishedAt
         *        The new value for the FinishedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * Sets the value of the StartedAt property for this object.
         *
         * @param startedAt
         *        The new value for the StartedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);
    }

    private static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataLocationS3;

        private String dataRearrangement;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Long dataSizeInBytes;

        private Long numberOfFiles;

        private String name;

        private String status;

        private String message;

        private RedshiftMetadata redshiftMetadata;

        private RDSMetadata rdsMetadata;

        private String roleARN;

        private Boolean computeStatistics;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            setDataSourceId(model.dataSourceId);
            setDataLocationS3(model.dataLocationS3);
            setDataRearrangement(model.dataRearrangement);
            setCreatedByIamUser(model.createdByIamUser);
            setCreatedAt(model.createdAt);
            setLastUpdatedAt(model.lastUpdatedAt);
            setDataSizeInBytes(model.dataSizeInBytes);
            setNumberOfFiles(model.numberOfFiles);
            setName(model.name);
            setStatus(model.status);
            setMessage(model.message);
            setRedshiftMetadata(model.redshiftMetadata);
            setRDSMetadata(model.rdsMetadata);
            setRoleARN(model.roleARN);
            setComputeStatistics(model.computeStatistics);
            setComputeTime(model.computeTime);
            setFinishedAt(model.finishedAt);
            setStartedAt(model.startedAt);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataLocationS3() {
            return dataLocationS3;
        }

        @Override
        public final Builder dataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
            return this;
        }

        public final void setDataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
        }

        public final String getDataRearrangement() {
            return dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getDataSizeInBytes() {
            return dataSizeInBytes;
        }

        @Override
        public final Builder dataSizeInBytes(Long dataSizeInBytes) {
            this.dataSizeInBytes = dataSizeInBytes;
            return this;
        }

        public final void setDataSizeInBytes(Long dataSizeInBytes) {
            this.dataSizeInBytes = dataSizeInBytes;
        }

        public final Long getNumberOfFiles() {
            return numberOfFiles;
        }

        @Override
        public final Builder numberOfFiles(Long numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
            return this;
        }

        public final void setNumberOfFiles(Long numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(EntityStatus status) {
            this.status(status.toString());
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final RedshiftMetadata getRedshiftMetadata() {
            return redshiftMetadata;
        }

        @Override
        public final Builder redshiftMetadata(RedshiftMetadata redshiftMetadata) {
            this.redshiftMetadata = redshiftMetadata;
            return this;
        }

        public final void setRedshiftMetadata(RedshiftMetadata redshiftMetadata) {
            this.redshiftMetadata = redshiftMetadata;
        }

        public final RDSMetadata getRDSMetadata() {
            return rdsMetadata;
        }

        @Override
        public final Builder rdsMetadata(RDSMetadata rdsMetadata) {
            this.rdsMetadata = rdsMetadata;
            return this;
        }

        public final void setRDSMetadata(RDSMetadata rdsMetadata) {
            this.rdsMetadata = rdsMetadata;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public DataSource build() {
            return new DataSource(this);
        }
    }
}
