/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeBatchPredictions</code> operation. The content is essentially a list of
 * <code>BatchPrediction</code>s.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBatchPredictionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeBatchPredictionsResponse.Builder, DescribeBatchPredictionsResponse> {
    private final List<BatchPrediction> results;

    private final String nextToken;

    private DescribeBatchPredictionsResponse(BuilderImpl builder) {
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>BatchPrediction</code> objects that meet the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>BatchPrediction</code> objects that meet the search criteria.
     */
    public List<BatchPrediction> results() {
        return results;
    }

    /**
     * <p>
     * The ID of the next page in the paginated results that indicates at least one more page follows.
     * </p>
     * 
     * @return The ID of the next page in the paginated results that indicates at least one more page follows.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((results() == null) ? 0 : results().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchPredictionsResponse)) {
            return false;
        }
        DescribeBatchPredictionsResponse other = (DescribeBatchPredictionsResponse) obj;
        if (other.results() == null ^ this.results() == null) {
            return false;
        }
        if (other.results() != null && !other.results().equals(this.results())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (results() != null) {
            sb.append("Results: ").append(results()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeBatchPredictionsResponse> {
        /**
         * <p>
         * A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<BatchPrediction> results);

        /**
         * <p>
         * A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(BatchPrediction... results);

        /**
         * <p>
         * The ID of the next page in the paginated results that indicates at least one more page follows.
         * </p>
         * 
         * @param nextToken
         *        The ID of the next page in the paginated results that indicates at least one more page follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<BatchPrediction> results;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchPredictionsResponse model) {
            setResults(model.results);
            setNextToken(model.nextToken);
        }

        public final Collection<BatchPrediction> getResults() {
            return results;
        }

        @Override
        public final Builder results(Collection<BatchPrediction> results) {
            this.results = BatchPredictionsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(BatchPrediction... results) {
            results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<BatchPrediction> results) {
            this.results = BatchPredictionsCopier.copy(results);
        }

        @SafeVarargs
        public final void setResults(BatchPrediction... results) {
            results(Arrays.asList(results));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBatchPredictionsResponse build() {
            return new DescribeBatchPredictionsResponse(this);
        }
    }
}
