/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RealtimeEndpointInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the real-time endpoint information for an <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RealtimeEndpointInfo implements StructuredPojo,
        ToCopyableBuilder<RealtimeEndpointInfo.Builder, RealtimeEndpointInfo> {
    private final Integer peakRequestsPerSecond;

    private final Instant createdAt;

    private final String endpointUrl;

    private final String endpointStatus;

    private RealtimeEndpointInfo(BuilderImpl builder) {
        this.peakRequestsPerSecond = builder.peakRequestsPerSecond;
        this.createdAt = builder.createdAt;
        this.endpointUrl = builder.endpointUrl;
        this.endpointStatus = builder.endpointStatus;
    }

    /**
     * <p>
     * The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming requests
     * per second.
     * </p>
     * 
     * @return The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming
     *         requests per second.
     */
    public Integer peakRequestsPerSecond() {
        return peakRequestsPerSecond;
    }

    /**
     * <p>
     * The time that the request to create the real-time endpoint for the <code>MLModel</code> was received. The time is
     * expressed in epoch time.
     * </p>
     * 
     * @return The time that the request to create the real-time endpoint for the <code>MLModel</code> was received. The
     *         time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.
     * </p>
     * <note><title>Note</title>
     * <p>
     * The application must wait until the real-time endpoint is ready before using this URI.
     * </p>
     * </note>
     * 
     * @return The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.</p>
     *         <note><title>Note</title>
     *         <p>
     *         The application must wait until the real-time endpoint is ready before using this URI.
     *         </p>
     */
    public String endpointUrl() {
        return endpointUrl;
    }

    /**
     * <p>
     * The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the
     * following values:
     * </p>
     * <ul>
     * <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
     * <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
     * <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
     * </ul>
     * 
     * @return The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of
     *         the following values: </p>
     *         <ul>
     *         <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
     *         <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
     *         <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
     * @see RealtimeEndpointStatus
     */
    public String endpointStatus() {
        return endpointStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((peakRequestsPerSecond() == null) ? 0 : peakRequestsPerSecond().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((endpointUrl() == null) ? 0 : endpointUrl().hashCode());
        hashCode = 31 * hashCode + ((endpointStatus() == null) ? 0 : endpointStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeEndpointInfo)) {
            return false;
        }
        RealtimeEndpointInfo other = (RealtimeEndpointInfo) obj;
        if (other.peakRequestsPerSecond() == null ^ this.peakRequestsPerSecond() == null) {
            return false;
        }
        if (other.peakRequestsPerSecond() != null && !other.peakRequestsPerSecond().equals(this.peakRequestsPerSecond())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.endpointUrl() == null ^ this.endpointUrl() == null) {
            return false;
        }
        if (other.endpointUrl() != null && !other.endpointUrl().equals(this.endpointUrl())) {
            return false;
        }
        if (other.endpointStatus() == null ^ this.endpointStatus() == null) {
            return false;
        }
        if (other.endpointStatus() != null && !other.endpointStatus().equals(this.endpointStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (peakRequestsPerSecond() != null) {
            sb.append("PeakRequestsPerSecond: ").append(peakRequestsPerSecond()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (endpointUrl() != null) {
            sb.append("EndpointUrl: ").append(endpointUrl()).append(",");
        }
        if (endpointStatus() != null) {
            sb.append("EndpointStatus: ").append(endpointStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RealtimeEndpointInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RealtimeEndpointInfo> {
        /**
         * <p>
         * The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming
         * requests per second.
         * </p>
         * 
         * @param peakRequestsPerSecond
         *        The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming
         *        requests per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peakRequestsPerSecond(Integer peakRequestsPerSecond);

        /**
         * <p>
         * The time that the request to create the real-time endpoint for the <code>MLModel</code> was received. The
         * time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the request to create the real-time endpoint for the <code>MLModel</code> was received.
         *        The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.
         * </p>
         * <note><title>Note</title>
         * <p>
         * The application must wait until the real-time endpoint is ready before using this URI.
         * </p>
         * </note>
         * 
         * @param endpointUrl
         *        The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.</p>
         *        <note><title>Note</title>
         *        <p>
         *        The application must wait until the real-time endpoint is ready before using this URI.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointUrl(String endpointUrl);

        /**
         * <p>
         * The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the
         * following values:
         * </p>
         * <ul>
         * <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         * <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         * <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * </ul>
         * 
         * @param endpointStatus
         *        The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one
         *        of the following values: </p>
         *        <ul>
         *        <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         *        <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         *        <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * @see RealtimeEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealtimeEndpointStatus
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the
         * following values:
         * </p>
         * <ul>
         * <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         * <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         * <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * </ul>
         * 
         * @param endpointStatus
         *        The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one
         *        of the following values: </p>
         *        <ul>
         *        <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         *        <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         *        <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * @see RealtimeEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealtimeEndpointStatus
         */
        Builder endpointStatus(RealtimeEndpointStatus endpointStatus);
    }

    private static final class BuilderImpl implements Builder {
        private Integer peakRequestsPerSecond;

        private Instant createdAt;

        private String endpointUrl;

        private String endpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeEndpointInfo model) {
            setPeakRequestsPerSecond(model.peakRequestsPerSecond);
            setCreatedAt(model.createdAt);
            setEndpointUrl(model.endpointUrl);
            setEndpointStatus(model.endpointStatus);
        }

        public final Integer getPeakRequestsPerSecond() {
            return peakRequestsPerSecond;
        }

        @Override
        public final Builder peakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
            return this;
        }

        public final void setPeakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getEndpointUrl() {
            return endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(RealtimeEndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus.toString());
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        public final void setEndpointStatus(RealtimeEndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus.toString());
        }

        @Override
        public RealtimeEndpointInfo build() {
            return new RealtimeEndpointInfo(this);
        }
    }
}
