/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.EntityStatus;
import software.amazon.awssdk.services.machinelearning.model.PerformanceMetrics;
import software.amazon.awssdk.services.machinelearning.transform.EvaluationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Evaluation
implements StructuredPojo,
ToCopyableBuilder<Builder, Evaluation> {
    private final String evaluationId;
    private final String mlModelId;
    private final String evaluationDataSourceId;
    private final String inputDataLocationS3;
    private final String createdByIamUser;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String status;
    private final PerformanceMetrics performanceMetrics;
    private final String message;
    private final Long computeTime;
    private final Instant finishedAt;
    private final Instant startedAt;

    private Evaluation(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.mlModelId = builder.mlModelId;
        this.evaluationDataSourceId = builder.evaluationDataSourceId;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.performanceMetrics = builder.performanceMetrics;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
    }

    public String evaluationId() {
        return this.evaluationId;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String evaluationDataSourceId() {
        return this.evaluationDataSourceId;
    }

    public String inputDataLocationS3() {
        return this.inputDataLocationS3;
    }

    public String createdByIamUser() {
        return this.createdByIamUser;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String name() {
        return this.name;
    }

    public String status() {
        return this.status;
    }

    public PerformanceMetrics performanceMetrics() {
        return this.performanceMetrics;
    }

    public String message() {
        return this.message;
    }

    public Long computeTime() {
        return this.computeTime;
    }

    public Instant finishedAt() {
        return this.finishedAt;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.evaluationId() == null ? 0 : this.evaluationId().hashCode());
        hashCode = 31 * hashCode + (this.mlModelId() == null ? 0 : this.mlModelId().hashCode());
        hashCode = 31 * hashCode + (this.evaluationDataSourceId() == null ? 0 : this.evaluationDataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.inputDataLocationS3() == null ? 0 : this.inputDataLocationS3().hashCode());
        hashCode = 31 * hashCode + (this.createdByIamUser() == null ? 0 : this.createdByIamUser().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedAt() == null ? 0 : this.lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.performanceMetrics() == null ? 0 : this.performanceMetrics().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.computeTime() == null ? 0 : this.computeTime().hashCode());
        hashCode = 31 * hashCode + (this.finishedAt() == null ? 0 : this.finishedAt().hashCode());
        hashCode = 31 * hashCode + (this.startedAt() == null ? 0 : this.startedAt().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation)obj;
        if (other.evaluationId() == null ^ this.evaluationId() == null) {
            return false;
        }
        if (other.evaluationId() != null && !other.evaluationId().equals(this.evaluationId())) {
            return false;
        }
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.evaluationDataSourceId() == null ^ this.evaluationDataSourceId() == null) {
            return false;
        }
        if (other.evaluationDataSourceId() != null && !other.evaluationDataSourceId().equals(this.evaluationDataSourceId())) {
            return false;
        }
        if (other.inputDataLocationS3() == null ^ this.inputDataLocationS3() == null) {
            return false;
        }
        if (other.inputDataLocationS3() != null && !other.inputDataLocationS3().equals(this.inputDataLocationS3())) {
            return false;
        }
        if (other.createdByIamUser() == null ^ this.createdByIamUser() == null) {
            return false;
        }
        if (other.createdByIamUser() != null && !other.createdByIamUser().equals(this.createdByIamUser())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.performanceMetrics() == null ^ this.performanceMetrics() == null) {
            return false;
        }
        if (other.performanceMetrics() != null && !other.performanceMetrics().equals(this.performanceMetrics())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.computeTime() == null ^ this.computeTime() == null) {
            return false;
        }
        if (other.computeTime() != null && !other.computeTime().equals(this.computeTime())) {
            return false;
        }
        if (other.finishedAt() == null ^ this.finishedAt() == null) {
            return false;
        }
        if (other.finishedAt() != null && !other.finishedAt().equals(this.finishedAt())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        return other.startedAt() == null || other.startedAt().equals(this.startedAt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evaluationId() != null) {
            sb.append("EvaluationId: ").append(this.evaluationId()).append(",");
        }
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.evaluationDataSourceId() != null) {
            sb.append("EvaluationDataSourceId: ").append(this.evaluationDataSourceId()).append(",");
        }
        if (this.inputDataLocationS3() != null) {
            sb.append("InputDataLocationS3: ").append(this.inputDataLocationS3()).append(",");
        }
        if (this.createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(this.createdByIamUser()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.lastUpdatedAt()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.performanceMetrics() != null) {
            sb.append("PerformanceMetrics: ").append(this.performanceMetrics()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.computeTime() != null) {
            sb.append("ComputeTime: ").append(this.computeTime()).append(",");
        }
        if (this.finishedAt() != null) {
            sb.append("FinishedAt: ").append(this.finishedAt()).append(",");
        }
        if (this.startedAt() != null) {
            sb.append("StartedAt: ").append(this.startedAt()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String evaluationId;
        private String mlModelId;
        private String evaluationDataSourceId;
        private String inputDataLocationS3;
        private String createdByIamUser;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String name;
        private String status;
        private PerformanceMetrics performanceMetrics;
        private String message;
        private Long computeTime;
        private Instant finishedAt;
        private Instant startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            this.setEvaluationId(model.evaluationId);
            this.setMLModelId(model.mlModelId);
            this.setEvaluationDataSourceId(model.evaluationDataSourceId);
            this.setInputDataLocationS3(model.inputDataLocationS3);
            this.setCreatedByIamUser(model.createdByIamUser);
            this.setCreatedAt(model.createdAt);
            this.setLastUpdatedAt(model.lastUpdatedAt);
            this.setName(model.name);
            this.setStatus(model.status);
            this.setPerformanceMetrics(model.performanceMetrics);
            this.setMessage(model.message);
            this.setComputeTime(model.computeTime);
            this.setFinishedAt(model.finishedAt);
            this.setStartedAt(model.startedAt);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getEvaluationDataSourceId() {
            return this.evaluationDataSourceId;
        }

        @Override
        public final Builder evaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
            return this;
        }

        public final void setEvaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
        }

        public final String getInputDataLocationS3() {
            return this.inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getCreatedByIamUser() {
            return this.createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(EntityStatus status) {
            this.status(status.toString());
        }

        public final PerformanceMetrics getPerformanceMetrics() {
            return this.performanceMetrics;
        }

        @Override
        public final Builder performanceMetrics(PerformanceMetrics performanceMetrics) {
            this.performanceMetrics = performanceMetrics;
            return this;
        }

        public final void setPerformanceMetrics(PerformanceMetrics performanceMetrics) {
            this.performanceMetrics = performanceMetrics;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return this.computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public Evaluation build() {
            return new Evaluation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Evaluation> {
        public Builder evaluationId(String var1);

        public Builder mlModelId(String var1);

        public Builder evaluationDataSourceId(String var1);

        public Builder inputDataLocationS3(String var1);

        public Builder createdByIamUser(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EntityStatus var1);

        public Builder performanceMetrics(PerformanceMetrics var1);

        public Builder message(String var1);

        public Builder computeTime(Long var1);

        public Builder finishedAt(Instant var1);

        public Builder startedAt(Instant var1);
    }
}

