/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import static software.amazon.awssdk.util.StringUtils.isNullOrEmpty;

import java.util.stream.Stream;
import javax.annotation.Generated;

/**
 * <p>
 * Object status with the following possible values:
 * </p>
 * <ul>
 * <li><code>PENDING</code></li>
 * <li><code>INPROGRESS</code></li>
 * <li><code>FAILED</code></li>
 * <li><code>COMPLETED</code></li>
 * <li><code>DELETED</code></li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum EntityStatus {
    PENDING("PENDING"),

    INPROGRESS("INPROGRESS"),

    FAILED("FAILED"),

    COMPLETED("COMPLETED"),

    DELETED("DELETED");

    private final String value;

    private EntityStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return EntityStatus corresponding to the value
     */
    public static EntityStatus fromValue(String value) {
        if (isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(EntityStatus.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}
