/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the query results from a <a>DescribeDataSources</a> operation. The content is essentially a list of
 * <code>DataSource</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDataSourcesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeDataSourcesResponse.Builder, DescribeDataSourcesResponse> {
    private final List<DataSource> results;

    private final String nextToken;

    private DescribeDataSourcesResponse(BuilderImpl builder) {
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>DataSource</code> that meet the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>DataSource</code> that meet the search criteria.
     */
    public List<DataSource> results() {
        return results;
    }

    /**
     * <p>
     * An ID of the next page in the paginated results that indicates at least one more page follows.
     * </p>
     * 
     * @return An ID of the next page in the paginated results that indicates at least one more page follows.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((results() == null) ? 0 : results().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSourcesResponse)) {
            return false;
        }
        DescribeDataSourcesResponse other = (DescribeDataSourcesResponse) obj;
        if (other.results() == null ^ this.results() == null) {
            return false;
        }
        if (other.results() != null && !other.results().equals(this.results())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (results() != null) {
            sb.append("Results: ").append(results()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDataSourcesResponse> {
        /**
         * <p>
         * A list of <code>DataSource</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>DataSource</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<DataSource> results);

        /**
         * <p>
         * A list of <code>DataSource</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>DataSource</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(DataSource... results);

        /**
         * <p>
         * An ID of the next page in the paginated results that indicates at least one more page follows.
         * </p>
         * 
         * @param nextToken
         *        An ID of the next page in the paginated results that indicates at least one more page follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<DataSource> results;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSourcesResponse model) {
            setResults(model.results);
            setNextToken(model.nextToken);
        }

        public final Collection<DataSource> getResults() {
            return results;
        }

        @Override
        public final Builder results(Collection<DataSource> results) {
            this.results = DataSourcesCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(DataSource... results) {
            results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<DataSource> results) {
            this.results = DataSourcesCopier.copy(results);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDataSourcesResponse build() {
            return new DescribeDataSourcesResponse(this);
        }
    }
}
