/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDataSourceFromS3Request extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDataSourceFromS3Request.Builder, CreateDataSourceFromS3Request> {
    private final String dataSourceId;

    private final String dataSourceName;

    private final S3DataSpec dataSpec;

    private final Boolean computeStatistics;

    private CreateDataSourceFromS3Request(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.computeStatistics = builder.computeStatistics;
    }

    /**
     * <p>
     * A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>DataSource</code>.
     */
    public String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The data specification of a <code>DataSource</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DataLocationS3 - The Amazon S3 location of the observation data.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     * <code>Datasource</code>.
     * </p>
     * <p>
     * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The data specification of a <code>DataSource</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DataLocationS3 - The Amazon S3 location of the observation data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     *         specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     *         <code>Datasource</code>.
     *         </p>
     *         <p>
     *         Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     *         </p>
     *         </li>
     */
    public S3DataSpec dataSpec() {
        return dataSpec;
    }

    /**
     * <p>
     * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
     * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
     * training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be
     * used for <code>MLModel</code> training.
     * </p>
     * 
     * @return The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation
     *         data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during
     *         <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>
     *         DataSource<code></code> needs to be used for <code>MLModel</code> training.
     */
    public Boolean computeStatistics() {
        return computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataSourceId() == null) ? 0 : dataSourceId().hashCode());
        hashCode = 31 * hashCode + ((dataSourceName() == null) ? 0 : dataSourceName().hashCode());
        hashCode = 31 * hashCode + ((dataSpec() == null) ? 0 : dataSpec().hashCode());
        hashCode = 31 * hashCode + ((computeStatistics() == null) ? 0 : computeStatistics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromS3Request)) {
            return false;
        }
        CreateDataSourceFromS3Request other = (CreateDataSourceFromS3Request) obj;
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataSourceName() == null ^ this.dataSourceName() == null) {
            return false;
        }
        if (other.dataSourceName() != null && !other.dataSourceName().equals(this.dataSourceName())) {
            return false;
        }
        if (other.dataSpec() == null ^ this.dataSpec() == null) {
            return false;
        }
        if (other.dataSpec() != null && !other.dataSpec().equals(this.dataSpec())) {
            return false;
        }
        if (other.computeStatistics() == null ^ this.computeStatistics() == null) {
            return false;
        }
        if (other.computeStatistics() != null && !other.computeStatistics().equals(this.computeStatistics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dataSourceId() != null) {
            sb.append("DataSourceId: ").append(dataSourceId()).append(",");
        }
        if (dataSourceName() != null) {
            sb.append("DataSourceName: ").append(dataSourceName()).append(",");
        }
        if (dataSpec() != null) {
            sb.append("DataSpec: ").append(dataSpec()).append(",");
        }
        if (computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(computeStatistics()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.of(clazz.cast(dataSourceId()));
        case "DataSourceName":
            return Optional.of(clazz.cast(dataSourceName()));
        case "DataSpec":
            return Optional.of(clazz.cast(dataSpec()));
        case "ComputeStatistics":
            return Optional.of(clazz.cast(computeStatistics()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDataSourceFromS3Request> {
        /**
         * <p>
         * A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceId
         *        A user-supplied identifier that uniquely identifies the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A user-supplied name or description of the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceName
         *        A user-supplied name or description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The data specification of a <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DataLocationS3 - The Amazon S3 location of the observation data.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>Datasource</code>.
         * </p>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataSpec
         *        The data specification of a <code>DataSource</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DataLocationS3 - The Amazon S3 location of the observation data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code>
         *        is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         *        <code>Datasource</code>.
         *        </p>
         *        <p>
         *        Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSpec(S3DataSpec dataSpec);

        /**
         * <p>
         * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
         * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
         * training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs
         * to be used for <code>MLModel</code> training.
         * </p>
         * 
         * @param computeStatistics
         *        The compute statistics for a <code>DataSource</code>. The statistics are generated from the
         *        observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally
         *        during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
         *        <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeStatistics(Boolean computeStatistics);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataSourceName;

        private S3DataSpec dataSpec;

        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromS3Request model) {
            dataSourceId(model.dataSourceId);
            dataSourceName(model.dataSourceName);
            dataSpec(model.dataSpec);
            computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final S3DataSpec.Builder getDataSpec() {
            return dataSpec != null ? dataSpec.toBuilder() : null;
        }

        @Override
        public final Builder dataSpec(S3DataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(S3DataSpec.BuilderImpl dataSpec) {
            this.dataSpec = dataSpec != null ? dataSpec.build() : null;
        }

        public final Boolean getComputeStatistics() {
            return computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public CreateDataSourceFromS3Request build() {
            return new CreateDataSourceFromS3Request(this);
        }
    }
}
