/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateMLModelRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateMLModelRequest.Builder, CreateMLModelRequest> {
    private final String mlModelId;

    private final String mlModelName;

    private final String mlModelType;

    private final Map<String, String> parameters;

    private final String trainingDataSourceId;

    private final String recipe;

    private final String recipeUri;

    private CreateMLModelRequest(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.mlModelType = builder.mlModelType;
        this.parameters = builder.parameters;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.recipe = builder.recipe;
        this.recipeUri = builder.recipeUri;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>MLModel</code>.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public String mlModelName() {
        return mlModelName;
    }

    /**
     * <p>
     * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:
     * </p>
     * <ul>
     * <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</li>
     * <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
     * <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
     * </ul>
     * <p>
     * For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
     * Learning Developer Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeString}.
     * </p>
     * 
     * @return The category of supervised learning that this <code>MLModel</code> will address. Choose from the
     *         following types:</p>
     *         <ul>
     *         <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</li>
     *         <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
     *         <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
     *         </ul>
     *         <p>
     *         For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
     *         Machine Learning Developer Guide</a>.
     * @see MLModelType
     */
    public MLModelType mlModelType() {
        return MLModelType.fromValue(mlModelType);
    }

    /**
     * <p>
     * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:
     * </p>
     * <ul>
     * <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</li>
     * <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
     * <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
     * </ul>
     * <p>
     * For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
     * Learning Developer Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeString}.
     * </p>
     * 
     * @return The category of supervised learning that this <code>MLModel</code> will address. Choose from the
     *         following types:</p>
     *         <ul>
     *         <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</li>
     *         <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
     *         <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
     *         </ul>
     *         <p>
     *         For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
     *         Machine Learning Developer Guide</a>.
     * @see MLModelType
     */
    public String mlModelTypeString() {
        return mlModelType;
    }

    /**
     * <p>
     * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
     * pairs.
     * </p>
     * <p>
     * The following is the current set of training parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the
     * size of the model might affect its performance.
     * </p>
     * <p>
     * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
     * <code>33554432</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build
     * the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The
     * default value is <code>10</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
     * model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code>
     * and <code>none</code>. The default value is <code>none</code>. We <?oxy_insert_start author="laurama"
     * timestamp="20160329T131121-0700">strongly recommend that you shuffle your data.<?oxy_insert_end>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature
     * set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1
     * normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this
     * parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2
     * normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
     *         key-value pairs.</p>
     *         <p>
     *         The following is the current set of training parameters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
     *         data, the size of the model might affect its performance.
     *         </p>
     *         <p>
     *         The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
     *         value is <code>33554432</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
     *         build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
     *         <code>10000</code>. The default value is <code>10</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves
     *         a model's ability to find the optimal solution for a variety of data types. The valid values are
     *         <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We <?oxy_insert_start
     *         author="laurama" timestamp="20160329T131121-0700">strongly recommend that you shuffle your
     *         data.<?oxy_insert_end>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a
     *         sparse feature set. If you use this parameter, start by specifying a small value, such as
     *         <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If
     *         you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The <code>DataSource</code> that points to the training data.
     * </p>
     * 
     * @return The <code>DataSource</code> that points to the training data.
     */
    public String trainingDataSourceId() {
        return trainingDataSourceId;
    }

    /**
     * <p>
     * The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you
     * don't specify a recipe or its URI, Amazon ML creates a default.
     * </p>
     * 
     * @return The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If
     *         you don't specify a recipe or its URI, Amazon ML creates a default.
     */
    public String recipe() {
        return recipe;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code>
     * recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML
     * creates a default.
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) location and file name that contains the
     *         <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe
     *         or its URI, Amazon ML creates a default.
     */
    public String recipeUri() {
        return recipeUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((mlModelName() == null) ? 0 : mlModelName().hashCode());
        hashCode = 31 * hashCode + ((mlModelTypeString() == null) ? 0 : mlModelTypeString().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((trainingDataSourceId() == null) ? 0 : trainingDataSourceId().hashCode());
        hashCode = 31 * hashCode + ((recipe() == null) ? 0 : recipe().hashCode());
        hashCode = 31 * hashCode + ((recipeUri() == null) ? 0 : recipeUri().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMLModelRequest)) {
            return false;
        }
        CreateMLModelRequest other = (CreateMLModelRequest) obj;
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.mlModelName() == null ^ this.mlModelName() == null) {
            return false;
        }
        if (other.mlModelName() != null && !other.mlModelName().equals(this.mlModelName())) {
            return false;
        }
        if (other.mlModelTypeString() == null ^ this.mlModelTypeString() == null) {
            return false;
        }
        if (other.mlModelTypeString() != null && !other.mlModelTypeString().equals(this.mlModelTypeString())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.trainingDataSourceId() == null ^ this.trainingDataSourceId() == null) {
            return false;
        }
        if (other.trainingDataSourceId() != null && !other.trainingDataSourceId().equals(this.trainingDataSourceId())) {
            return false;
        }
        if (other.recipe() == null ^ this.recipe() == null) {
            return false;
        }
        if (other.recipe() != null && !other.recipe().equals(this.recipe())) {
            return false;
        }
        if (other.recipeUri() == null ^ this.recipeUri() == null) {
            return false;
        }
        if (other.recipeUri() != null && !other.recipeUri().equals(this.recipeUri())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (mlModelName() != null) {
            sb.append("MLModelName: ").append(mlModelName()).append(",");
        }
        if (mlModelTypeString() != null) {
            sb.append("MLModelType: ").append(mlModelTypeString()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (trainingDataSourceId() != null) {
            sb.append("TrainingDataSourceId: ").append(trainingDataSourceId()).append(",");
        }
        if (recipe() != null) {
            sb.append("Recipe: ").append(recipe()).append(",");
        }
        if (recipeUri() != null) {
            sb.append("RecipeUri: ").append(recipeUri()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        case "MLModelName":
            return Optional.of(clazz.cast(mlModelName()));
        case "MLModelType":
            return Optional.of(clazz.cast(mlModelTypeString()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        case "TrainingDataSourceId":
            return Optional.of(clazz.cast(trainingDataSourceId()));
        case "Recipe":
            return Optional.of(clazz.cast(recipe()));
        case "RecipeUri":
            return Optional.of(clazz.cast(recipeUri()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateMLModelRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelId
         *        A user-supplied ID that uniquely identifies the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelName
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelName(String mlModelName);

        /**
         * <p>
         * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following
         * types:
         * </p>
         * <ul>
         * <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</li>
         * <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
         * <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
         * </ul>
         * <p>
         * For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
         * Learning Developer Guide</a>.
         * </p>
         * 
         * @param mlModelType
         *        The category of supervised learning that this <code>MLModel</code> will address. Choose from the
         *        following types:</p>
         *        <ul>
         *        <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric
         *        value.</li>
         *        <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
         *        <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
         *        </ul>
         *        <p>
         *        For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
         *        Machine Learning Developer Guide</a>.
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(String mlModelType);

        /**
         * <p>
         * The category of supervised learning that this <code>MLModel</code> will address. Choose from the following
         * types:
         * </p>
         * <ul>
         * <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</li>
         * <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
         * <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
         * </ul>
         * <p>
         * For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
         * Learning Developer Guide</a>.
         * </p>
         * 
         * @param mlModelType
         *        The category of supervised learning that this <code>MLModel</code> will address. Choose from the
         *        following types:</p>
         *        <ul>
         *        <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric
         *        value.</li>
         *        <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li>
         *        <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</li>
         *        </ul>
         *        <p>
         *        For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
         *        Machine Learning Developer Guide</a>.
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(MLModelType mlModelType);

        /**
         * <p>
         * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
         * pairs.
         * </p>
         * <p>
         * The following is the current set of training parameters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data,
         * the size of the model might affect its performance.
         * </p>
         * <p>
         * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
         * <code>33554432</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
         * build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>
         * . The default value is <code>10</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
         * model's ability to find the optimal solution for a variety of data types. The valid values are
         * <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We <?oxy_insert_start
         * author="laurama" timestamp="20160329T131121-0700">strongly recommend that you shuffle your
         * data.<?oxy_insert_end>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse
         * feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use
         * this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param parameters
         *        A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
         *        key-value pairs.</p>
         *        <p>
         *        The following is the current set of training parameters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
         *        data, the size of the model might affect its performance.
         *        </p>
         *        <p>
         *        The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
         *        value is <code>33554432</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations
         *        to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
         *        <code>10000</code>. The default value is <code>10</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data
         *        improves a model's ability to find the optimal solution for a variety of data types. The valid values
         *        are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We
         *        <?oxy_insert_start author="laurama" timestamp="20160329T131121-0700">strongly recommend that you
         *        shuffle your data.<?oxy_insert_end>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero,
         *        resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such
         *        as <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to small,
         *        nonzero values. If you use this parameter, start by specifying a small value, such as
         *        <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The <code>DataSource</code> that points to the training data.
         * </p>
         * 
         * @param trainingDataSourceId
         *        The <code>DataSource</code> that points to the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSourceId(String trainingDataSourceId);

        /**
         * <p>
         * The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you
         * don't specify a recipe or its URI, Amazon ML creates a default.
         * </p>
         * 
         * @param recipe
         *        The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI.
         *        If you don't specify a recipe or its URI, Amazon ML creates a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipe(String recipe);

        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code>
         * recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML
         * creates a default.
         * </p>
         * 
         * @param recipeUri
         *        The Amazon Simple Storage Service (Amazon S3) location and file name that contains the
         *        <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a
         *        recipe or its URI, Amazon ML creates a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeUri(String recipeUri);
    }

    static final class BuilderImpl implements Builder {
        private String mlModelId;

        private String mlModelName;

        private String mlModelType;

        private Map<String, String> parameters;

        private String trainingDataSourceId;

        private String recipe;

        private String recipeUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMLModelRequest model) {
            mlModelId(model.mlModelId);
            mlModelName(model.mlModelName);
            mlModelType(model.mlModelType);
            parameters(model.parameters);
            trainingDataSourceId(model.trainingDataSourceId);
            recipe(model.recipe);
            recipeUri(model.recipeUri);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMLModelName() {
            return mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMLModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final String getMLModelType() {
            return mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
            return this;
        }

        public final void setMLModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
        }

        public final String getTrainingDataSourceId() {
            return trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getRecipe() {
            return recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        public final String getRecipeUri() {
            return recipeUri;
        }

        @Override
        public final Builder recipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
            return this;
        }

        public final void setRecipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
        }

        @Override
        public CreateMLModelRequest build() {
            return new CreateMLModelRequest(this);
        }
    }
}
