/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Generated;

/**
 * <p>
 * A list of the variables to use in searching or filtering <code>DataSource</code>.
 * </p>
 * <ul>
 * <li> <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation date.</li>
 * <li> <code>Status</code> - Sets the search criteria to <code>DataSource</code> status.</li>
 * <li> <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <b> </b>
 * <code>Name</code>.</li>
 * <li> <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
 * <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or
 * directory.</li>
 * <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code>
 * creation.</li>
 * </ul>
 * <note><title>Note</title>
 * <p>
 * The variable names should match the variable names in the <code>DataSource</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public enum DataSourceFilterVariable {
    CREATED_AT("CreatedAt"),

    LAST_UPDATED_AT("LastUpdatedAt"),

    STATUS("Status"),

    NAME("Name"),

    DATA_LOCATIONS3("DataLocationS3"),

    IAM_USER("IAMUser"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSourceFilterVariable(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DataSourceFilterVariable corresponding to the value
     */
    public static DataSourceFilterVariable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSourceFilterVariable.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DataSourceFilterVariable}s
     */
    public static Set<DataSourceFilterVariable> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
