/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteTagsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteTagsRequest.Builder, DeleteTagsRequest> {
    private final List<String> tagKeys;

    private final String resourceId;

    private final String resourceType;

    private DeleteTagsRequest(BuilderImpl builder) {
        this.tagKeys = builder.tagKeys;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * One or more tags to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags to delete.
     */
    public List<String> tagKeys() {
        return tagKeys;
    }

    /**
     * <p>
     * The ID of the tagged ML object. For example, <code>exampleModelId</code>.
     * </p>
     * 
     * @return The ID of the tagged ML object. For example, <code>exampleModelId</code>.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the tagged ML object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the tagged ML object.
     * @see TaggableResourceType
     */
    public TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the tagged ML object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the tagged ML object.
     * @see TaggableResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tagKeys() == null) ? 0 : tagKeys().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((resourceTypeString() == null) ? 0 : resourceTypeString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest) obj;
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.resourceTypeString() == null ^ this.resourceTypeString() == null) {
            return false;
        }
        if (other.resourceTypeString() != null && !other.resourceTypeString().equals(this.resourceTypeString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tagKeys() != null) {
            sb.append("TagKeys: ").append(tagKeys()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagKeys":
            return Optional.of(clazz.cast(tagKeys()));
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteTagsRequest> {
        /**
         * <p>
         * One or more tags to delete.
         * </p>
         * 
         * @param tagKeys
         *        One or more tags to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * One or more tags to delete.
         * </p>
         * 
         * @param tagKeys
         *        One or more tags to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);

        /**
         * <p>
         * The ID of the tagged ML object. For example, <code>exampleModelId</code>.
         * </p>
         * 
         * @param resourceId
         *        The ID of the tagged ML object. For example, <code>exampleModelId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the tagged ML object.
         * </p>
         * 
         * @param resourceType
         *        The type of the tagged ML object.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the tagged ML object.
         * </p>
         * 
         * @param resourceType
         *        The type of the tagged ML object.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(TaggableResourceType resourceType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> tagKeys;

        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsRequest model) {
            tagKeys(model.tagKeys);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final Collection<String> getTagKeys() {
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public DeleteTagsRequest build() {
            return new DeleteTagsRequest(this);
        }
    }
}
