/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBatchPredictionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetBatchPredictionRequest.Builder, GetBatchPredictionRequest> {
    private final String batchPredictionId;

    private GetBatchPredictionRequest(BuilderImpl builder) {
        this.batchPredictionId = builder.batchPredictionId;
    }

    /**
     * <p>
     * An ID assigned to the <code>BatchPrediction</code> at creation.
     * </p>
     * 
     * @return An ID assigned to the <code>BatchPrediction</code> at creation.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((batchPredictionId() == null) ? 0 : batchPredictionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBatchPredictionRequest)) {
            return false;
        }
        GetBatchPredictionRequest other = (GetBatchPredictionRequest) obj;
        if (other.batchPredictionId() == null ^ this.batchPredictionId() == null) {
            return false;
        }
        if (other.batchPredictionId() != null && !other.batchPredictionId().equals(this.batchPredictionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (batchPredictionId() != null) {
            sb.append("BatchPredictionId: ").append(batchPredictionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.of(clazz.cast(batchPredictionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBatchPredictionRequest> {
        /**
         * <p>
         * An ID assigned to the <code>BatchPrediction</code> at creation.
         * </p>
         * 
         * @param batchPredictionId
         *        An ID assigned to the <code>BatchPrediction</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);
    }

    static final class BuilderImpl implements Builder {
        private String batchPredictionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBatchPredictionRequest model) {
            batchPredictionId(model.batchPredictionId);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        public GetBatchPredictionRequest build() {
            return new GetBatchPredictionRequest(this);
        }
    }
}
