/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDataSourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetDataSourceRequest.Builder, GetDataSourceRequest> {
    private final String dataSourceId;

    private final Boolean verbose;

    private GetDataSourceRequest(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.verbose = builder.verbose;
    }

    /**
     * <p>
     * The ID assigned to the <code>DataSource</code> at creation.
     * </p>
     * 
     * @return The ID assigned to the <code>DataSource</code> at creation.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.
     * </p>
     * <p>
     * If true, <code>DataSourceSchema</code> is returned.
     * </p>
     * <p>
     * If false, <code>DataSourceSchema</code> is not returned.
     * </p>
     * 
     * @return Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>
     *         .</p>
     *         <p>
     *         If true, <code>DataSourceSchema</code> is returned.
     *         </p>
     *         <p>
     *         If false, <code>DataSourceSchema</code> is not returned.
     */
    public Boolean verbose() {
        return verbose;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataSourceId() == null) ? 0 : dataSourceId().hashCode());
        hashCode = 31 * hashCode + ((verbose() == null) ? 0 : verbose().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceRequest)) {
            return false;
        }
        GetDataSourceRequest other = (GetDataSourceRequest) obj;
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.verbose() == null ^ this.verbose() == null) {
            return false;
        }
        if (other.verbose() != null && !other.verbose().equals(this.verbose())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dataSourceId() != null) {
            sb.append("DataSourceId: ").append(dataSourceId()).append(",");
        }
        if (verbose() != null) {
            sb.append("Verbose: ").append(verbose()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.of(clazz.cast(dataSourceId()));
        case "Verbose":
            return Optional.of(clazz.cast(verbose()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDataSourceRequest> {
        /**
         * <p>
         * The ID assigned to the <code>DataSource</code> at creation.
         * </p>
         * 
         * @param dataSourceId
         *        The ID assigned to the <code>DataSource</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.
         * </p>
         * <p>
         * If true, <code>DataSourceSchema</code> is returned.
         * </p>
         * <p>
         * If false, <code>DataSourceSchema</code> is not returned.
         * </p>
         * 
         * @param verbose
         *        Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>
         *        .</p>
         *        <p>
         *        If true, <code>DataSourceSchema</code> is returned.
         *        </p>
         *        <p>
         *        If false, <code>DataSourceSchema</code> is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verbose(Boolean verbose);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceRequest model) {
            dataSourceId(model.dataSourceId);
            verbose(model.verbose);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final Boolean getVerbose() {
            return verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public GetDataSourceRequest build() {
            return new GetDataSourceRequest(this);
        }
    }
}
