/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetDataSource</code> operation and describes a <code>DataSource</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDataSourceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDataSourceResponse.Builder, GetDataSourceResponse> {
    private final String dataSourceId;

    private final String dataLocationS3;

    private final String dataRearrangement;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Long dataSizeInBytes;

    private final Long numberOfFiles;

    private final String name;

    private final String status;

    private final String logUri;

    private final String message;

    private final RedshiftMetadata redshiftMetadata;

    private final RDSMetadata rdsMetadata;

    private final String roleARN;

    private final Boolean computeStatistics;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private final String dataSourceSchema;

    private GetDataSourceResponse(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataLocationS3 = builder.dataLocationS3;
        this.dataRearrangement = builder.dataRearrangement;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.dataSizeInBytes = builder.dataSizeInBytes;
        this.numberOfFiles = builder.numberOfFiles;
        this.name = builder.name;
        this.status = builder.status;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.redshiftMetadata = builder.redshiftMetadata;
        this.rdsMetadata = builder.rdsMetadata;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.dataSourceSchema = builder.dataSourceSchema;
    }

    /**
     * <p>
     * The ID assigned to the <code>DataSource</code> at creation. This value should be identical to the value of the
     * <code>DataSourceId</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>DataSource</code> at creation. This value should be identical to the value
     *         of the <code>DataSourceId</code> in the request.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public String dataLocationS3() {
        return dataLocationS3;
    }

    /**
     * <p>
     * A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code>
     * was created.
     * </p>
     * 
     * @return A JSON string that represents the splitting and rearrangement requirement used when this
     *         <code>DataSource</code> was created.
     */
    public String dataRearrangement() {
        return dataRearrangement;
    }

    /**
     * <p>
     * The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS
     * root account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account from which the <code>DataSource</code> was created. The account type can be either
     *         an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The total size of observations in the data files.
     * </p>
     * 
     * @return The total size of observations in the data files.
     */
    public Long dataSizeInBytes() {
        return dataSizeInBytes;
    }

    /**
     * <p>
     * The number of data files referenced by the <code>DataSource</code>.
     * </p>
     * 
     * @return The number of data files referenced by the <code>DataSource</code>.
     */
    public Long numberOfFiles() {
        return numberOfFiles;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>DataSource</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the <code>DataSource</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
     * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     * <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not
     * usable.</li>
     * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the <code>DataSource</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
     *         <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     *         <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It
     *         is not usable.</li>
     *         <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public EntityStatus status() {
        return EntityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the <code>DataSource</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
     * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     * <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not
     * usable.</li>
     * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the <code>DataSource</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
     *         <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     *         <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It
     *         is not usable.</li>
     *         <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.
     * </p>
     * 
     * @return A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.
     */
    public String logUri() {
        return logUri;
    }

    /**
     * <p>
     * The user-supplied description of the most recent details about creating the <code>DataSource</code>.
     * </p>
     * 
     * @return The user-supplied description of the most recent details about creating the <code>DataSource</code>.
     */
    public String message() {
        return message;
    }

    /**
     * Returns the value of the RedshiftMetadata property for this object.
     * 
     * @return The value of the RedshiftMetadata property for this object.
     */
    public RedshiftMetadata redshiftMetadata() {
        return redshiftMetadata;
    }

    /**
     * Returns the value of the RDSMetadata property for this object.
     * 
     * @return The value of the RDSMetadata property for this object.
     */
    public RDSMetadata rdsMetadata() {
        return rdsMetadata;
    }

    /**
     * Returns the value of the RoleARN property for this object.
     * 
     * @return The value of the RoleARN property for this object.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The parameter is <code>true</code> if statistics need to be generated from the observation data.
     * </p>
     * 
     * @return The parameter is <code>true</code> if statistics need to be generated from the observation data.
     */
    public Boolean computeStatistics() {
        return computeStatistics;
    }

    /**
     * <p>
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
     * <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
     * available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the
     * <code>ComputeStatistics</code> is set to true.
     * </p>
     * 
     * @return The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
     *         <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
     *         available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the
     *         <code>ComputeStatistics</code> is set to true.
     */
    public Long computeTime() {
        return computeTime;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or
     * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the
     * <code>COMPLETED</code> or <code>FAILED</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code>
     *         or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in
     *         the <code>COMPLETED</code> or <code>FAILED</code> state.
     */
    public Instant finishedAt() {
        return finishedAt;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>.
     * <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>
     *         . <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code>
     *         state.
     */
    public Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The schema used by all of the data files of this <code>DataSource</code>.
     * </p>
     * <note><title>Note</title>
     * <p>
     * This parameter is provided as part of the verbose format.
     * </p>
     * </note>
     * 
     * @return The schema used by all of the data files of this <code>DataSource</code>.</p> <note><title>Note</title>
     *         <p>
     *         This parameter is provided as part of the verbose format.
     *         </p>
     */
    public String dataSourceSchema() {
        return dataSourceSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataSourceId() == null) ? 0 : dataSourceId().hashCode());
        hashCode = 31 * hashCode + ((dataLocationS3() == null) ? 0 : dataLocationS3().hashCode());
        hashCode = 31 * hashCode + ((dataRearrangement() == null) ? 0 : dataRearrangement().hashCode());
        hashCode = 31 * hashCode + ((createdByIamUser() == null) ? 0 : createdByIamUser().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedAt() == null) ? 0 : lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((dataSizeInBytes() == null) ? 0 : dataSizeInBytes().hashCode());
        hashCode = 31 * hashCode + ((numberOfFiles() == null) ? 0 : numberOfFiles().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((logUri() == null) ? 0 : logUri().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((redshiftMetadata() == null) ? 0 : redshiftMetadata().hashCode());
        hashCode = 31 * hashCode + ((rdsMetadata() == null) ? 0 : rdsMetadata().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((computeStatistics() == null) ? 0 : computeStatistics().hashCode());
        hashCode = 31 * hashCode + ((computeTime() == null) ? 0 : computeTime().hashCode());
        hashCode = 31 * hashCode + ((finishedAt() == null) ? 0 : finishedAt().hashCode());
        hashCode = 31 * hashCode + ((startedAt() == null) ? 0 : startedAt().hashCode());
        hashCode = 31 * hashCode + ((dataSourceSchema() == null) ? 0 : dataSourceSchema().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceResponse)) {
            return false;
        }
        GetDataSourceResponse other = (GetDataSourceResponse) obj;
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataLocationS3() == null ^ this.dataLocationS3() == null) {
            return false;
        }
        if (other.dataLocationS3() != null && !other.dataLocationS3().equals(this.dataLocationS3())) {
            return false;
        }
        if (other.dataRearrangement() == null ^ this.dataRearrangement() == null) {
            return false;
        }
        if (other.dataRearrangement() != null && !other.dataRearrangement().equals(this.dataRearrangement())) {
            return false;
        }
        if (other.createdByIamUser() == null ^ this.createdByIamUser() == null) {
            return false;
        }
        if (other.createdByIamUser() != null && !other.createdByIamUser().equals(this.createdByIamUser())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.dataSizeInBytes() == null ^ this.dataSizeInBytes() == null) {
            return false;
        }
        if (other.dataSizeInBytes() != null && !other.dataSizeInBytes().equals(this.dataSizeInBytes())) {
            return false;
        }
        if (other.numberOfFiles() == null ^ this.numberOfFiles() == null) {
            return false;
        }
        if (other.numberOfFiles() != null && !other.numberOfFiles().equals(this.numberOfFiles())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.logUri() == null ^ this.logUri() == null) {
            return false;
        }
        if (other.logUri() != null && !other.logUri().equals(this.logUri())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.redshiftMetadata() == null ^ this.redshiftMetadata() == null) {
            return false;
        }
        if (other.redshiftMetadata() != null && !other.redshiftMetadata().equals(this.redshiftMetadata())) {
            return false;
        }
        if (other.rdsMetadata() == null ^ this.rdsMetadata() == null) {
            return false;
        }
        if (other.rdsMetadata() != null && !other.rdsMetadata().equals(this.rdsMetadata())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.computeStatistics() == null ^ this.computeStatistics() == null) {
            return false;
        }
        if (other.computeStatistics() != null && !other.computeStatistics().equals(this.computeStatistics())) {
            return false;
        }
        if (other.computeTime() == null ^ this.computeTime() == null) {
            return false;
        }
        if (other.computeTime() != null && !other.computeTime().equals(this.computeTime())) {
            return false;
        }
        if (other.finishedAt() == null ^ this.finishedAt() == null) {
            return false;
        }
        if (other.finishedAt() != null && !other.finishedAt().equals(this.finishedAt())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        if (other.dataSourceSchema() == null ^ this.dataSourceSchema() == null) {
            return false;
        }
        if (other.dataSourceSchema() != null && !other.dataSourceSchema().equals(this.dataSourceSchema())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dataSourceId() != null) {
            sb.append("DataSourceId: ").append(dataSourceId()).append(",");
        }
        if (dataLocationS3() != null) {
            sb.append("DataLocationS3: ").append(dataLocationS3()).append(",");
        }
        if (dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(dataRearrangement()).append(",");
        }
        if (createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(createdByIamUser()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(lastUpdatedAt()).append(",");
        }
        if (dataSizeInBytes() != null) {
            sb.append("DataSizeInBytes: ").append(dataSizeInBytes()).append(",");
        }
        if (numberOfFiles() != null) {
            sb.append("NumberOfFiles: ").append(numberOfFiles()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (logUri() != null) {
            sb.append("LogUri: ").append(logUri()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (redshiftMetadata() != null) {
            sb.append("RedshiftMetadata: ").append(redshiftMetadata()).append(",");
        }
        if (rdsMetadata() != null) {
            sb.append("RDSMetadata: ").append(rdsMetadata()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(computeStatistics()).append(",");
        }
        if (computeTime() != null) {
            sb.append("ComputeTime: ").append(computeTime()).append(",");
        }
        if (finishedAt() != null) {
            sb.append("FinishedAt: ").append(finishedAt()).append(",");
        }
        if (startedAt() != null) {
            sb.append("StartedAt: ").append(startedAt()).append(",");
        }
        if (dataSourceSchema() != null) {
            sb.append("DataSourceSchema: ").append(dataSourceSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.of(clazz.cast(dataSourceId()));
        case "DataLocationS3":
            return Optional.of(clazz.cast(dataLocationS3()));
        case "DataRearrangement":
            return Optional.of(clazz.cast(dataRearrangement()));
        case "CreatedByIamUser":
            return Optional.of(clazz.cast(createdByIamUser()));
        case "CreatedAt":
            return Optional.of(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.of(clazz.cast(lastUpdatedAt()));
        case "DataSizeInBytes":
            return Optional.of(clazz.cast(dataSizeInBytes()));
        case "NumberOfFiles":
            return Optional.of(clazz.cast(numberOfFiles()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "LogUri":
            return Optional.of(clazz.cast(logUri()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        case "RedshiftMetadata":
            return Optional.of(clazz.cast(redshiftMetadata()));
        case "RDSMetadata":
            return Optional.of(clazz.cast(rdsMetadata()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "ComputeStatistics":
            return Optional.of(clazz.cast(computeStatistics()));
        case "ComputeTime":
            return Optional.of(clazz.cast(computeTime()));
        case "FinishedAt":
            return Optional.of(clazz.cast(finishedAt()));
        case "StartedAt":
            return Optional.of(clazz.cast(startedAt()));
        case "DataSourceSchema":
            return Optional.of(clazz.cast(dataSourceSchema()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDataSourceResponse> {
        /**
         * <p>
         * The ID assigned to the <code>DataSource</code> at creation. This value should be identical to the value of
         * the <code>DataSourceId</code> in the request.
         * </p>
         * 
         * @param dataSourceId
         *        The ID assigned to the <code>DataSource</code> at creation. This value should be identical to the
         *        value of the <code>DataSourceId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param dataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocationS3(String dataLocationS3);

        /**
         * <p>
         * A JSON string that represents the splitting and rearrangement requirement used when this
         * <code>DataSource</code> was created.
         * </p>
         * 
         * @param dataRearrangement
         *        A JSON string that represents the splitting and rearrangement requirement used when this
         *        <code>DataSource</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRearrangement(String dataRearrangement);

        /**
         * <p>
         * The AWS user account from which the <code>DataSource</code> was created. The account type can be either an
         * AWS root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account from which the <code>DataSource</code> was created. The account type can be
         *        either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>DataSource</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The total size of observations in the data files.
         * </p>
         * 
         * @param dataSizeInBytes
         *        The total size of observations in the data files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSizeInBytes(Long dataSizeInBytes);

        /**
         * <p>
         * The number of data files referenced by the <code>DataSource</code>.
         * </p>
         * 
         * @param numberOfFiles
         *        The number of data files referenced by the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFiles(Long numberOfFiles);

        /**
         * <p>
         * A user-supplied name or description of the <code>DataSource</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the <code>DataSource</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
         * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         * <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is
         * not usable.</li>
         * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>DataSource</code>. This element can have one of the following
         *        values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
         *        <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         *        <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion.
         *        It is not usable.</li>
         *        <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the <code>DataSource</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
         * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         * <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is
         * not usable.</li>
         * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>DataSource</code>. This element can have one of the following
         *        values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li>
         *        <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         *        <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion.
         *        It is not usable.</li>
         *        <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * <p>
         * A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.
         * </p>
         * 
         * @param logUri
         *        A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * The user-supplied description of the most recent details about creating the <code>DataSource</code>.
         * </p>
         * 
         * @param message
         *        The user-supplied description of the most recent details about creating the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * Sets the value of the RedshiftMetadata property for this object.
         *
         * @param redshiftMetadata
         *        The new value for the RedshiftMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftMetadata(RedshiftMetadata redshiftMetadata);

        /**
         * Sets the value of the RDSMetadata property for this object.
         *
         * @param rdsMetadata
         *        The new value for the RDSMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsMetadata(RDSMetadata rdsMetadata);

        /**
         * Sets the value of the RoleARN property for this object.
         *
         * @param roleARN
         *        The new value for the RoleARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The parameter is <code>true</code> if statistics need to be generated from the observation data.
         * </p>
         * 
         * @param computeStatistics
         *        The parameter is <code>true</code> if statistics need to be generated from the observation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeStatistics(Boolean computeStatistics);

        /**
         * <p>
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         * <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
         * available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the
         * <code>ComputeStatistics</code> is set to true.
         * </p>
         * 
         * @param computeTime
         *        The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         *        <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is
         *        only available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the
         *        <code>ComputeStatistics</code> is set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or
         * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the
         * <code>COMPLETED</code> or <code>FAILED</code> state.
         * </p>
         * 
         * @param finishedAt
         *        The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as
         *        <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the
         *        <code>DataSource</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>.
         * <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code> state.
         * </p>
         * 
         * @param startedAt
         *        The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as
         *        <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>DataSource</code> is in
         *        the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The schema used by all of the data files of this <code>DataSource</code>.
         * </p>
         * <note><title>Note</title>
         * <p>
         * This parameter is provided as part of the verbose format.
         * </p>
         * </note>
         * 
         * @param dataSourceSchema
         *        The schema used by all of the data files of this <code>DataSource</code>.</p>
         *        <note><title>Note</title>
         *        <p>
         *        This parameter is provided as part of the verbose format.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceSchema(String dataSourceSchema);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataLocationS3;

        private String dataRearrangement;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Long dataSizeInBytes;

        private Long numberOfFiles;

        private String name;

        private String status;

        private String logUri;

        private String message;

        private RedshiftMetadata redshiftMetadata;

        private RDSMetadata rdsMetadata;

        private String roleARN;

        private Boolean computeStatistics;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private String dataSourceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceResponse model) {
            dataSourceId(model.dataSourceId);
            dataLocationS3(model.dataLocationS3);
            dataRearrangement(model.dataRearrangement);
            createdByIamUser(model.createdByIamUser);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            dataSizeInBytes(model.dataSizeInBytes);
            numberOfFiles(model.numberOfFiles);
            name(model.name);
            status(model.status);
            logUri(model.logUri);
            message(model.message);
            redshiftMetadata(model.redshiftMetadata);
            rdsMetadata(model.rdsMetadata);
            roleARN(model.roleARN);
            computeStatistics(model.computeStatistics);
            computeTime(model.computeTime);
            finishedAt(model.finishedAt);
            startedAt(model.startedAt);
            dataSourceSchema(model.dataSourceSchema);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataLocationS3() {
            return dataLocationS3;
        }

        @Override
        public final Builder dataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
            return this;
        }

        public final void setDataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
        }

        public final String getDataRearrangement() {
            return dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getDataSizeInBytes() {
            return dataSizeInBytes;
        }

        @Override
        public final Builder dataSizeInBytes(Long dataSizeInBytes) {
            this.dataSizeInBytes = dataSizeInBytes;
            return this;
        }

        public final void setDataSizeInBytes(Long dataSizeInBytes) {
            this.dataSizeInBytes = dataSizeInBytes;
        }

        public final Long getNumberOfFiles() {
            return numberOfFiles;
        }

        @Override
        public final Builder numberOfFiles(Long numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
            return this;
        }

        public final void setNumberOfFiles(Long numberOfFiles) {
            this.numberOfFiles = numberOfFiles;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLogUri() {
            return logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final RedshiftMetadata.Builder getRedshiftMetadata() {
            return redshiftMetadata != null ? redshiftMetadata.toBuilder() : null;
        }

        @Override
        public final Builder redshiftMetadata(RedshiftMetadata redshiftMetadata) {
            this.redshiftMetadata = redshiftMetadata;
            return this;
        }

        public final void setRedshiftMetadata(RedshiftMetadata.BuilderImpl redshiftMetadata) {
            this.redshiftMetadata = redshiftMetadata != null ? redshiftMetadata.build() : null;
        }

        public final RDSMetadata.Builder getRDSMetadata() {
            return rdsMetadata != null ? rdsMetadata.toBuilder() : null;
        }

        @Override
        public final Builder rdsMetadata(RDSMetadata rdsMetadata) {
            this.rdsMetadata = rdsMetadata;
            return this;
        }

        public final void setRDSMetadata(RDSMetadata.BuilderImpl rdsMetadata) {
            this.rdsMetadata = rdsMetadata != null ? rdsMetadata.build() : null;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final String getDataSourceSchema() {
            return dataSourceSchema;
        }

        @Override
        public final Builder dataSourceSchema(String dataSourceSchema) {
            this.dataSourceSchema = dataSourceSchema;
            return this;
        }

        public final void setDataSourceSchema(String dataSourceSchema) {
            this.dataSourceSchema = dataSourceSchema;
        }

        @Override
        public GetDataSourceResponse build() {
            return new GetDataSourceResponse(this);
        }
    }
}
