/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetEvaluationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetEvaluationRequest.Builder, GetEvaluationRequest> {
    private final String evaluationId;

    private GetEvaluationRequest(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
    }

    /**
     * <p>
     * The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and
     * cataloged. The ID provides the means to access the information.
     * </p>
     * 
     * @return The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is
     *         recorded and cataloged. The ID provides the means to access the information.
     */
    public String evaluationId() {
        return evaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((evaluationId() == null) ? 0 : evaluationId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvaluationRequest)) {
            return false;
        }
        GetEvaluationRequest other = (GetEvaluationRequest) obj;
        if (other.evaluationId() == null ^ this.evaluationId() == null) {
            return false;
        }
        if (other.evaluationId() != null && !other.evaluationId().equals(this.evaluationId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (evaluationId() != null) {
            sb.append("EvaluationId: ").append(evaluationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.of(clazz.cast(evaluationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetEvaluationRequest> {
        /**
         * <p>
         * The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded
         * and cataloged. The ID provides the means to access the information.
         * </p>
         * 
         * @param evaluationId
         *        The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is
         *        recorded and cataloged. The ID provides the means to access the information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvaluationRequest model) {
            evaluationId(model.evaluationId);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public GetEvaluationRequest build() {
            return new GetEvaluationRequest(this);
        }
    }
}
