/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetMLModel</code> operation, and provides detailed information about a
 * <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMLModelResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetMLModelResponse.Builder, GetMLModelResponse> {
    private final String mlModelId;

    private final String trainingDataSourceId;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String status;

    private final Long sizeInBytes;

    private final RealtimeEndpointInfo endpointInfo;

    private final Map<String, String> trainingParameters;

    private final String inputDataLocationS3;

    private final String mlModelType;

    private final Float scoreThreshold;

    private final Instant scoreThresholdLastUpdatedAt;

    private final String logUri;

    private final String message;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private final String recipe;

    private final String schema;

    private GetMLModelResponse(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.sizeInBytes = builder.sizeInBytes;
        this.endpointInfo = builder.endpointInfo;
        this.trainingParameters = builder.trainingParameters;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.mlModelType = builder.mlModelType;
        this.scoreThreshold = builder.scoreThreshold;
        this.scoreThresholdLastUpdatedAt = builder.scoreThresholdLastUpdatedAt;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.recipe = builder.recipe;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The MLModel ID<?oxy_insert_start author="annbech" timestamp="20160328T151251-0700">,<?oxy_insert_end> which is
     * same as the <code>MLModelId</code> in the request.
     * </p>
     * 
     * @return The MLModel ID<?oxy_insert_start author="annbech" timestamp="20160328T151251-0700">,<?oxy_insert_end>
     *         which is same as the <code>MLModelId</code> in the request.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the training <code>DataSource</code>.
     * </p>
     * 
     * @return The ID of the training <code>DataSource</code>.
     */
    public String trainingDataSourceId() {
        return trainingDataSourceId;
    }

    /**
     * <p>
     * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root
     * account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account from which the <code>MLModel</code> was created. The account type can be either an
     *         AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the <code>MLModel</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
     * <code>MLModel</code>.</li>
     * <li> <code>INPROGRESS</code> - The request is processing.</li>
     * <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
     * <li> <code>COMPLETED</code> - The request completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
     *         <code>MLModel</code>.</li>
     *         <li> <code>INPROGRESS</code> - The request is processing.</li>
     *         <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
     *         <li> <code>COMPLETED</code> - The request completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * @see EntityStatus
     */
    public EntityStatus status() {
        return EntityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the <code>MLModel</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
     * <code>MLModel</code>.</li>
     * <li> <code>INPROGRESS</code> - The request is processing.</li>
     * <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
     * <li> <code>COMPLETED</code> - The request completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
     *         <code>MLModel</code>.</li>
     *         <li> <code>INPROGRESS</code> - The request is processing.</li>
     *         <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
     *         <li> <code>COMPLETED</code> - The request completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * @see EntityStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * Returns the value of the SizeInBytes property for this object.
     * 
     * @return The value of the SizeInBytes property for this object.
     */
    public Long sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The current endpoint of the <code>MLModel</code>
     * </p>
     * 
     * @return The current endpoint of the <code>MLModel</code>
     */
    public RealtimeEndpointInfo endpointInfo() {
        return endpointInfo;
    }

    /**
     * <p>
     * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
     * pairs.
     * </p>
     * <p>
     * The following is the current set of training parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the
     * size of the model might affect its performance.
     * </p>
     * <p>
     * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
     * <code>33554432</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build
     * the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The
     * default value is <code>10</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a model's
     * ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and
     * <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature
     * set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1
     * normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this
     * parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2
     * normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
     *         key-value pairs.</p>
     *         <p>
     *         The following is the current set of training parameters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
     *         data, the size of the model might affect its performance.
     *         </p>
     *         <p>
     *         The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
     *         value is <code>33554432</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
     *         build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
     *         <code>10000</code>. The default value is <code>10</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
     *         model's ability to find the optimal solution for a variety of data types. The valid values are
     *         <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend
     *         that you shuffle your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a
     *         sparse feature set. If you use this parameter, start by specifying a small value, such as
     *         <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting
     *         the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If
     *         you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     */
    public Map<String, String> trainingParameters() {
        return trainingParameters;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public String inputDataLocationS3() {
        return inputDataLocationS3;
    }

    /**
     * <p>
     * Identifies the <code>MLModel</code> category. The following are the available types:
     * </p>
     * <ul>
     * <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
     * <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
     * <li>MULTICLASS -- Produces one of several possible results. For example,
     * "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeString}.
     * </p>
     * 
     * @return Identifies the <code>MLModel</code> category. The following are the available types: </p>
     *         <ul>
     *         <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
     *         <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
     *         <li>MULTICLASS -- Produces one of several possible results. For example,
     *         "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
     * @see MLModelType
     */
    public MLModelType mlModelType() {
        return MLModelType.fromValue(mlModelType);
    }

    /**
     * <p>
     * Identifies the <code>MLModel</code> category. The following are the available types:
     * </p>
     * <ul>
     * <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
     * <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
     * <li>MULTICLASS -- Produces one of several possible results. For example,
     * "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeString}.
     * </p>
     * 
     * @return Identifies the <code>MLModel</code> category. The following are the available types: </p>
     *         <ul>
     *         <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
     *         <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
     *         <li>MULTICLASS -- Produces one of several possible results. For example,
     *         "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
     * @see MLModelType
     */
    public String mlModelTypeString() {
        return mlModelType;
    }

    /**
     * <p>
     * The scoring threshold is used in binary classification <code>MLModel</code><?oxy_insert_start author="laurama"
     * timestamp="20160329T114851-0700"> <?oxy_insert_end>models. It marks the boundary between a positive prediction
     * and a negative prediction.
     * </p>
     * <p>
     * Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
     * <code>true</code>. Output values less than the threshold receive a negative response from the MLModel, such as
     * <code>false</code>.
     * </p>
     * 
     * @return The scoring threshold is used in binary classification <code>MLModel</code><?oxy_insert_start
     *         author="laurama" timestamp="20160329T114851-0700"> <?oxy_insert_end>models. It marks the boundary between
     *         a positive prediction and a negative prediction.</p>
     *         <p>
     *         Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
     *         <code>true</code>. Output values less than the threshold receive a negative response from the MLModel,
     *         such as <code>false</code>.
     */
    public Float scoreThreshold() {
        return scoreThreshold;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     */
    public Instant scoreThresholdLastUpdatedAt() {
        return scoreThresholdLastUpdatedAt;
    }

    /**
     * <p>
     * A link to the file that contains logs of the <code>CreateMLModel</code> operation.
     * </p>
     * 
     * @return A link to the file that contains logs of the <code>CreateMLModel</code> operation.
     */
    public String logUri() {
        return logUri;
    }

    /**
     * <p>
     * A description of the most recent details about accessing the <code>MLModel</code>.
     * </p>
     * 
     * @return A description of the most recent details about accessing the <code>MLModel</code>.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>,
     * normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the
     * <code>MLModel</code> is in the <code>COMPLETED</code> state.
     * </p>
     * 
     * @return The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
     *         <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
     *         available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.
     */
    public Long computeTime() {
        return computeTime;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or
     * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the
     * <code>COMPLETED</code> or <code>FAILED</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or
     *         <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the
     *         <code>COMPLETED</code> or <code>FAILED</code> state.
     */
    public Instant finishedAt() {
        return finishedAt;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>.
     * <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>.
     *         <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.
     */
    public Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed information
     * about the observation data to use during training, and manipulations to perform on the observation data during
     * training.
     * </p>
     * <note><title>Note</title>
     * <p>
     * This parameter is provided as part of the verbose format.
     * </p>
     * </note>
     * 
     * @return The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed
     *         information about the observation data to use during training, and manipulations to perform on the
     *         observation data during training.</p> <note><title>Note</title>
     *         <p>
     *         This parameter is provided as part of the verbose format.
     *         </p>
     */
    public String recipe() {
        return recipe;
    }

    /**
     * <p>
     * The schema used by all of the data files referenced by the <code>DataSource</code>.
     * </p>
     * <note><title>Note</title>
     * <p>
     * This parameter is provided as part of the verbose format.
     * </p>
     * </note>
     * 
     * @return The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
     *         <note><title>Note</title>
     *         <p>
     *         This parameter is provided as part of the verbose format.
     *         </p>
     */
    public String schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((trainingDataSourceId() == null) ? 0 : trainingDataSourceId().hashCode());
        hashCode = 31 * hashCode + ((createdByIamUser() == null) ? 0 : createdByIamUser().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedAt() == null) ? 0 : lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((sizeInBytes() == null) ? 0 : sizeInBytes().hashCode());
        hashCode = 31 * hashCode + ((endpointInfo() == null) ? 0 : endpointInfo().hashCode());
        hashCode = 31 * hashCode + ((trainingParameters() == null) ? 0 : trainingParameters().hashCode());
        hashCode = 31 * hashCode + ((inputDataLocationS3() == null) ? 0 : inputDataLocationS3().hashCode());
        hashCode = 31 * hashCode + ((mlModelTypeString() == null) ? 0 : mlModelTypeString().hashCode());
        hashCode = 31 * hashCode + ((scoreThreshold() == null) ? 0 : scoreThreshold().hashCode());
        hashCode = 31 * hashCode + ((scoreThresholdLastUpdatedAt() == null) ? 0 : scoreThresholdLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((logUri() == null) ? 0 : logUri().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((computeTime() == null) ? 0 : computeTime().hashCode());
        hashCode = 31 * hashCode + ((finishedAt() == null) ? 0 : finishedAt().hashCode());
        hashCode = 31 * hashCode + ((startedAt() == null) ? 0 : startedAt().hashCode());
        hashCode = 31 * hashCode + ((recipe() == null) ? 0 : recipe().hashCode());
        hashCode = 31 * hashCode + ((schema() == null) ? 0 : schema().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMLModelResponse)) {
            return false;
        }
        GetMLModelResponse other = (GetMLModelResponse) obj;
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.trainingDataSourceId() == null ^ this.trainingDataSourceId() == null) {
            return false;
        }
        if (other.trainingDataSourceId() != null && !other.trainingDataSourceId().equals(this.trainingDataSourceId())) {
            return false;
        }
        if (other.createdByIamUser() == null ^ this.createdByIamUser() == null) {
            return false;
        }
        if (other.createdByIamUser() != null && !other.createdByIamUser().equals(this.createdByIamUser())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.sizeInBytes() == null ^ this.sizeInBytes() == null) {
            return false;
        }
        if (other.sizeInBytes() != null && !other.sizeInBytes().equals(this.sizeInBytes())) {
            return false;
        }
        if (other.endpointInfo() == null ^ this.endpointInfo() == null) {
            return false;
        }
        if (other.endpointInfo() != null && !other.endpointInfo().equals(this.endpointInfo())) {
            return false;
        }
        if (other.trainingParameters() == null ^ this.trainingParameters() == null) {
            return false;
        }
        if (other.trainingParameters() != null && !other.trainingParameters().equals(this.trainingParameters())) {
            return false;
        }
        if (other.inputDataLocationS3() == null ^ this.inputDataLocationS3() == null) {
            return false;
        }
        if (other.inputDataLocationS3() != null && !other.inputDataLocationS3().equals(this.inputDataLocationS3())) {
            return false;
        }
        if (other.mlModelTypeString() == null ^ this.mlModelTypeString() == null) {
            return false;
        }
        if (other.mlModelTypeString() != null && !other.mlModelTypeString().equals(this.mlModelTypeString())) {
            return false;
        }
        if (other.scoreThreshold() == null ^ this.scoreThreshold() == null) {
            return false;
        }
        if (other.scoreThreshold() != null && !other.scoreThreshold().equals(this.scoreThreshold())) {
            return false;
        }
        if (other.scoreThresholdLastUpdatedAt() == null ^ this.scoreThresholdLastUpdatedAt() == null) {
            return false;
        }
        if (other.scoreThresholdLastUpdatedAt() != null
                && !other.scoreThresholdLastUpdatedAt().equals(this.scoreThresholdLastUpdatedAt())) {
            return false;
        }
        if (other.logUri() == null ^ this.logUri() == null) {
            return false;
        }
        if (other.logUri() != null && !other.logUri().equals(this.logUri())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.computeTime() == null ^ this.computeTime() == null) {
            return false;
        }
        if (other.computeTime() != null && !other.computeTime().equals(this.computeTime())) {
            return false;
        }
        if (other.finishedAt() == null ^ this.finishedAt() == null) {
            return false;
        }
        if (other.finishedAt() != null && !other.finishedAt().equals(this.finishedAt())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        if (other.recipe() == null ^ this.recipe() == null) {
            return false;
        }
        if (other.recipe() != null && !other.recipe().equals(this.recipe())) {
            return false;
        }
        if (other.schema() == null ^ this.schema() == null) {
            return false;
        }
        if (other.schema() != null && !other.schema().equals(this.schema())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (trainingDataSourceId() != null) {
            sb.append("TrainingDataSourceId: ").append(trainingDataSourceId()).append(",");
        }
        if (createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(createdByIamUser()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(lastUpdatedAt()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (sizeInBytes() != null) {
            sb.append("SizeInBytes: ").append(sizeInBytes()).append(",");
        }
        if (endpointInfo() != null) {
            sb.append("EndpointInfo: ").append(endpointInfo()).append(",");
        }
        if (trainingParameters() != null) {
            sb.append("TrainingParameters: ").append(trainingParameters()).append(",");
        }
        if (inputDataLocationS3() != null) {
            sb.append("InputDataLocationS3: ").append(inputDataLocationS3()).append(",");
        }
        if (mlModelTypeString() != null) {
            sb.append("MLModelType: ").append(mlModelTypeString()).append(",");
        }
        if (scoreThreshold() != null) {
            sb.append("ScoreThreshold: ").append(scoreThreshold()).append(",");
        }
        if (scoreThresholdLastUpdatedAt() != null) {
            sb.append("ScoreThresholdLastUpdatedAt: ").append(scoreThresholdLastUpdatedAt()).append(",");
        }
        if (logUri() != null) {
            sb.append("LogUri: ").append(logUri()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (computeTime() != null) {
            sb.append("ComputeTime: ").append(computeTime()).append(",");
        }
        if (finishedAt() != null) {
            sb.append("FinishedAt: ").append(finishedAt()).append(",");
        }
        if (startedAt() != null) {
            sb.append("StartedAt: ").append(startedAt()).append(",");
        }
        if (recipe() != null) {
            sb.append("Recipe: ").append(recipe()).append(",");
        }
        if (schema() != null) {
            sb.append("Schema: ").append(schema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        case "TrainingDataSourceId":
            return Optional.of(clazz.cast(trainingDataSourceId()));
        case "CreatedByIamUser":
            return Optional.of(clazz.cast(createdByIamUser()));
        case "CreatedAt":
            return Optional.of(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.of(clazz.cast(lastUpdatedAt()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "SizeInBytes":
            return Optional.of(clazz.cast(sizeInBytes()));
        case "EndpointInfo":
            return Optional.of(clazz.cast(endpointInfo()));
        case "TrainingParameters":
            return Optional.of(clazz.cast(trainingParameters()));
        case "InputDataLocationS3":
            return Optional.of(clazz.cast(inputDataLocationS3()));
        case "MLModelType":
            return Optional.of(clazz.cast(mlModelTypeString()));
        case "ScoreThreshold":
            return Optional.of(clazz.cast(scoreThreshold()));
        case "ScoreThresholdLastUpdatedAt":
            return Optional.of(clazz.cast(scoreThresholdLastUpdatedAt()));
        case "LogUri":
            return Optional.of(clazz.cast(logUri()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        case "ComputeTime":
            return Optional.of(clazz.cast(computeTime()));
        case "FinishedAt":
            return Optional.of(clazz.cast(finishedAt()));
        case "StartedAt":
            return Optional.of(clazz.cast(startedAt()));
        case "Recipe":
            return Optional.of(clazz.cast(recipe()));
        case "Schema":
            return Optional.of(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetMLModelResponse> {
        /**
         * <p>
         * The MLModel ID<?oxy_insert_start author="annbech" timestamp="20160328T151251-0700">,<?oxy_insert_end> which
         * is same as the <code>MLModelId</code> in the request.
         * </p>
         * 
         * @param mlModelId
         *        The MLModel ID<?oxy_insert_start author="annbech" timestamp="20160328T151251-0700">,<?oxy_insert_end>
         *        which is same as the <code>MLModelId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the training <code>DataSource</code>.
         * </p>
         * 
         * @param trainingDataSourceId
         *        The ID of the training <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSourceId(String trainingDataSourceId);

        /**
         * <p>
         * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS
         * root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account from which the <code>MLModel</code> was created. The account type can be either
         *        an AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The request is processing.</li>
         * <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
         * <li> <code>COMPLETED</code> - The request completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The request is processing.</li>
         *        <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
         *        <li> <code>COMPLETED</code> - The request completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The request is processing.</li>
         * <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
         * <li> <code>COMPLETED</code> - The request completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The request is processing.</li>
         *        <li> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</li>
         *        <li> <code>COMPLETED</code> - The request completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * Sets the value of the SizeInBytes property for this object.
         *
         * @param sizeInBytes
         *        The new value for the SizeInBytes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);

        /**
         * <p>
         * The current endpoint of the <code>MLModel</code>
         * </p>
         * 
         * @param endpointInfo
         *        The current endpoint of the <code>MLModel</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointInfo(RealtimeEndpointInfo endpointInfo);

        /**
         * <p>
         * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
         * pairs.
         * </p>
         * <p>
         * The following is the current set of training parameters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data,
         * the size of the model might affect its performance.
         * </p>
         * <p>
         * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
         * <code>33554432</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
         * build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>
         * . The default value is <code>10</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
         * model's ability to find the optimal solution for a variety of data types. The valid values are
         * <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that
         * you shuffle your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse
         * feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the
         * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use
         * this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trainingParameters
         *        A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
         *        key-value pairs.</p>
         *        <p>
         *        The following is the current set of training parameters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
         *        data, the size of the model might affect its performance.
         *        </p>
         *        <p>
         *        The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
         *        value is <code>33554432</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations
         *        to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
         *        <code>10000</code>. The default value is <code>10</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
         *        model's ability to find the optimal solution for a variety of data types. The valid values are
         *        <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend
         *        that you shuffle your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero,
         *        resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such
         *        as <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to small,
         *        nonzero values. If you use this parameter, start by specifying a small value, such as
         *        <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingParameters(Map<String, String> trainingParameters);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param inputDataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataLocationS3(String inputDataLocationS3);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
         * <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
         * <li>MULTICLASS -- Produces one of several possible results. For example,
         * "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types: </p>
         *        <ul>
         *        <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
         *        <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
         *        <li>MULTICLASS -- Produces one of several possible results. For example,
         *        "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(String mlModelType);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
         * <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
         * <li>MULTICLASS -- Produces one of several possible results. For example,
         * "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types: </p>
         *        <ul>
         *        <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li>
         *        <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li>
         *        <li>MULTICLASS -- Produces one of several possible results. For example,
         *        "Is this a HIGH, LOW or MEDIUM risk trade?"</li>
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(MLModelType mlModelType);

        /**
         * <p>
         * The scoring threshold is used in binary classification <code>MLModel</code><?oxy_insert_start
         * author="laurama" timestamp="20160329T114851-0700"> <?oxy_insert_end>models. It marks the boundary between a
         * positive prediction and a negative prediction.
         * </p>
         * <p>
         * Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
         * <code>true</code>. Output values less than the threshold receive a negative response from the MLModel, such
         * as <code>false</code>.
         * </p>
         * 
         * @param scoreThreshold
         *        The scoring threshold is used in binary classification <code>MLModel</code><?oxy_insert_start
         *        author="laurama" timestamp="20160329T114851-0700"> <?oxy_insert_end>models. It marks the boundary
         *        between a positive prediction and a negative prediction.</p>
         *        <p>
         *        Output values greater than or equal to the threshold receive a positive result from the MLModel, such
         *        as <code>true</code>. Output values less than the threshold receive a negative response from the
         *        MLModel, such as <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThreshold(Float scoreThreshold);

        /**
         * <p>
         * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param scoreThresholdLastUpdatedAt
         *        The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt);

        /**
         * <p>
         * A link to the file that contains logs of the <code>CreateMLModel</code> operation.
         * </p>
         * 
         * @param logUri
         *        A link to the file that contains logs of the <code>CreateMLModel</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * A description of the most recent details about accessing the <code>MLModel</code>.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about accessing the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         * <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
         * available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.
         * </p>
         * 
         * @param computeTime
         *        The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         *        <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
         *        available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or
         * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the
         * <code>COMPLETED</code> or <code>FAILED</code> state.
         * </p>
         * 
         * @param finishedAt
         *        The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code>
         *        or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in
         *        the <code>COMPLETED</code> or <code>FAILED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>.
         * <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.
         * </p>
         * 
         * @param startedAt
         *        The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>
         *        . <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code>
         *        state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed
         * information about the observation data to use during training, and manipulations to perform on the
         * observation data during training.
         * </p>
         * <note><title>Note</title>
         * <p>
         * This parameter is provided as part of the verbose format.
         * </p>
         * </note>
         * 
         * @param recipe
         *        The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed
         *        information about the observation data to use during training, and manipulations to perform on the
         *        observation data during training.</p> <note><title>Note</title>
         *        <p>
         *        This parameter is provided as part of the verbose format.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipe(String recipe);

        /**
         * <p>
         * The schema used by all of the data files referenced by the <code>DataSource</code>.
         * </p>
         * <note><title>Note</title>
         * <p>
         * This parameter is provided as part of the verbose format.
         * </p>
         * </note>
         * 
         * @param schema
         *        The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
         *        <note><title>Note</title>
         *        <p>
         *        This parameter is provided as part of the verbose format.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);
    }

    static final class BuilderImpl implements Builder {
        private String mlModelId;

        private String trainingDataSourceId;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String name;

        private String status;

        private Long sizeInBytes;

        private RealtimeEndpointInfo endpointInfo;

        private Map<String, String> trainingParameters;

        private String inputDataLocationS3;

        private String mlModelType;

        private Float scoreThreshold;

        private Instant scoreThresholdLastUpdatedAt;

        private String logUri;

        private String message;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private String recipe;

        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMLModelResponse model) {
            mlModelId(model.mlModelId);
            trainingDataSourceId(model.trainingDataSourceId);
            createdByIamUser(model.createdByIamUser);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            status(model.status);
            sizeInBytes(model.sizeInBytes);
            endpointInfo(model.endpointInfo);
            trainingParameters(model.trainingParameters);
            inputDataLocationS3(model.inputDataLocationS3);
            mlModelType(model.mlModelType);
            scoreThreshold(model.scoreThreshold);
            scoreThresholdLastUpdatedAt(model.scoreThresholdLastUpdatedAt);
            logUri(model.logUri);
            message(model.message);
            computeTime(model.computeTime);
            finishedAt(model.finishedAt);
            startedAt(model.startedAt);
            recipe(model.recipe);
            schema(model.schema);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getTrainingDataSourceId() {
            return trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final RealtimeEndpointInfo.Builder getEndpointInfo() {
            return endpointInfo != null ? endpointInfo.toBuilder() : null;
        }

        @Override
        public final Builder endpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final void setEndpointInfo(RealtimeEndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        public final Map<String, String> getTrainingParameters() {
            return trainingParameters;
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        public final String getInputDataLocationS3() {
            return inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getMLModelType() {
            return mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
            return this;
        }

        public final void setMLModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final Float getScoreThreshold() {
            return scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public final Instant getScoreThresholdLastUpdatedAt() {
            return scoreThresholdLastUpdatedAt;
        }

        @Override
        public final Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
            return this;
        }

        public final void setScoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
        }

        public final String getLogUri() {
            return logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final String getRecipe() {
            return recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public GetMLModelResponse build() {
            return new GetMLModelResponse(this);
        }
    }
}
