/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.PerformanceMetricsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Measurements of how well the <code>MLModel</code> performed on known observations. One of the following metrics is
 * returned, based on the type of the <code>MLModel</code>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * BinaryAUC: The binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance.
 * </p>
 * </li>
 * <li>
 * <p>
 * RegressionRMSE: The regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure
 * performance. RMSE measures the difference between predicted and actual values for a single variable.
 * </p>
 * </li>
 * <li>
 * <p>
 * MulticlassAvgFScore: The multiclass <code>MLModel</code> uses the F1 score technique to measure performance.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about performance metrics, please see the <a
 * href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PerformanceMetrics implements StructuredPojo, ToCopyableBuilder<PerformanceMetrics.Builder, PerformanceMetrics> {
    private final Map<String, String> properties;

    private PerformanceMetrics(BuilderImpl builder) {
        this.properties = builder.properties;
    }

    /**
     * Returns the value of the Properties property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Properties property for this object.
     */
    public Map<String, String> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((properties() == null) ? 0 : properties().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceMetrics)) {
            return false;
        }
        PerformanceMetrics other = (PerformanceMetrics) obj;
        if (other.properties() == null ^ this.properties() == null) {
            return false;
        }
        if (other.properties() != null && !other.properties().equals(this.properties())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (properties() != null) {
            sb.append("Properties: ").append(properties()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Properties":
            return Optional.of(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PerformanceMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PerformanceMetrics> {
        /**
         * Sets the value of the Properties property for this object.
         *
         * @param properties
         *        The new value for the Properties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> properties;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceMetrics model) {
            properties(model.properties);
        }

        public final Map<String, String> getProperties() {
            return properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = PerformanceMetricsPropertiesCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = PerformanceMetricsPropertiesCopier.copy(properties);
        }

        @Override
        public PerformanceMetrics build() {
            return new PerformanceMetrics(this);
        }
    }
}
