/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PredictResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PredictResponse.Builder, PredictResponse> {
    private final Prediction prediction;

    private PredictResponse(BuilderImpl builder) {
        this.prediction = builder.prediction;
    }

    /**
     * Returns the value of the Prediction property for this object.
     * 
     * @return The value of the Prediction property for this object.
     */
    public Prediction prediction() {
        return prediction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((prediction() == null) ? 0 : prediction().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictResponse)) {
            return false;
        }
        PredictResponse other = (PredictResponse) obj;
        if (other.prediction() == null ^ this.prediction() == null) {
            return false;
        }
        if (other.prediction() != null && !other.prediction().equals(this.prediction())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (prediction() != null) {
            sb.append("Prediction: ").append(prediction()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prediction":
            return Optional.of(clazz.cast(prediction()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PredictResponse> {
        /**
         * Sets the value of the Prediction property for this object.
         *
         * @param prediction
         *        The new value for the Prediction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prediction(Prediction prediction);
    }

    static final class BuilderImpl implements Builder {
        private Prediction prediction;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictResponse model) {
            prediction(model.prediction);
        }

        public final Prediction.Builder getPrediction() {
            return prediction != null ? prediction.toBuilder() : null;
        }

        @Override
        public final Builder prediction(Prediction prediction) {
            this.prediction = prediction;
            return this;
        }

        public final void setPrediction(Prediction.BuilderImpl prediction) {
            this.prediction = prediction != null ? prediction.build() : null;
        }

        @Override
        public PredictResponse build() {
            return new PredictResponse(this);
        }
    }
}
