/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.machinelearning.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * EvaluationMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class EvaluationMarshaller {

    private static final MarshallingInfo<String> EVALUATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationId").build();
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").build();
    private static final MarshallingInfo<String> EVALUATIONDATASOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationDataSourceId").build();
    private static final MarshallingInfo<String> INPUTDATALOCATIONS3_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataLocationS3").build();
    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").build();
    private static final MarshallingInfo<java.time.Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").build();
    private static final MarshallingInfo<java.time.Instant> LASTUPDATEDAT_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt")
            .build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> PERFORMANCEMETRICS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PerformanceMetrics").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").build();
    private static final MarshallingInfo<java.time.Instant> FINISHEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").build();
    private static final MarshallingInfo<java.time.Instant> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").build();

    private static final EvaluationMarshaller INSTANCE = new EvaluationMarshaller();

    public static EvaluationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Evaluation evaluation, ProtocolMarshaller protocolMarshaller) {

        if (evaluation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(evaluation.evaluationId(), EVALUATIONID_BINDING);

            protocolMarshaller.marshall(evaluation.mlModelId(), MLMODELID_BINDING);

            protocolMarshaller.marshall(evaluation.evaluationDataSourceId(), EVALUATIONDATASOURCEID_BINDING);

            protocolMarshaller.marshall(evaluation.inputDataLocationS3(), INPUTDATALOCATIONS3_BINDING);

            protocolMarshaller.marshall(evaluation.createdByIamUser(), CREATEDBYIAMUSER_BINDING);

            protocolMarshaller.marshall(evaluation.createdAt(), CREATEDAT_BINDING);

            protocolMarshaller.marshall(evaluation.lastUpdatedAt(), LASTUPDATEDAT_BINDING);

            protocolMarshaller.marshall(evaluation.name(), NAME_BINDING);

            protocolMarshaller.marshall(evaluation.statusString(), STATUS_BINDING);

            protocolMarshaller.marshall(evaluation.performanceMetrics(), PERFORMANCEMETRICS_BINDING);

            protocolMarshaller.marshall(evaluation.message(), MESSAGE_BINDING);

            protocolMarshaller.marshall(evaluation.computeTime(), COMPUTETIME_BINDING);

            protocolMarshaller.marshall(evaluation.finishedAt(), FINISHEDAT_BINDING);

            protocolMarshaller.marshall(evaluation.startedAt(), STARTEDAT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
