/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.machinelearning.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetEvaluationResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetEvaluationResponseUnmarshaller implements Unmarshaller<GetEvaluationResponse, JsonUnmarshallerContext> {

    public GetEvaluationResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetEvaluationResponse.Builder getEvaluationResponseBuilder = GetEvaluationResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getEvaluationResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("EvaluationId", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.evaluationId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MLModelId", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.mlModelId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EvaluationDataSourceId", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder
                            .evaluationDataSourceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InputDataLocationS3", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.inputDataLocationS3(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedByIamUser", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.createdByIamUser(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("LastUpdatedAt", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.lastUpdatedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PerformanceMetrics", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.performanceMetrics(PerformanceMetricsUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("LogUri", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.logUri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Message", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.message(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComputeTime", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.computeTime(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("FinishedAt", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.finishedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("StartedAt", targetDepth)) {
                    context.nextToken();
                    getEvaluationResponseBuilder.startedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getEvaluationResponseBuilder.build();
    }

    private static final GetEvaluationResponseUnmarshaller INSTANCE = new GetEvaluationResponseUnmarshaller();

    public static GetEvaluationResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
