/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateEvaluationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateEvaluationRequest.Builder, CreateEvaluationRequest> {
    private final String evaluationId;

    private final String evaluationName;

    private final String mlModelId;

    private final String evaluationDataSourceId;

    private CreateEvaluationRequest(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationName = builder.evaluationName;
        this.mlModelId = builder.mlModelId;
        this.evaluationDataSourceId = builder.evaluationDataSourceId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>Evaluation</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>Evaluation</code>.
     */
    public String evaluationId() {
        return evaluationId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>Evaluation</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>Evaluation</code>.
     */
    public String evaluationName() {
        return evaluationName;
    }

    /**
     * <p>
     * The ID of the <code>MLModel</code> to evaluate.
     * </p>
     * <p>
     * The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in
     * the <code>Evaluation</code>.
     * </p>
     * 
     * @return The ID of the <code>MLModel</code> to evaluate.</p>
     *         <p>
     *         The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code>
     *         used in the <code>Evaluation</code>.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code> must match
     * the schema used to create the <code>MLModel</code>.
     * </p>
     * 
     * @return The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code> must
     *         match the schema used to create the <code>MLModel</code>.
     */
    public String evaluationDataSourceId() {
        return evaluationDataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationName());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataSourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationRequest)) {
            return false;
        }
        CreateEvaluationRequest other = (CreateEvaluationRequest) obj;
        return Objects.equals(evaluationId(), other.evaluationId()) && Objects.equals(evaluationName(), other.evaluationName())
                && Objects.equals(mlModelId(), other.mlModelId())
                && Objects.equals(evaluationDataSourceId(), other.evaluationDataSourceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (evaluationId() != null) {
            sb.append("EvaluationId: ").append(evaluationId()).append(",");
        }
        if (evaluationName() != null) {
            sb.append("EvaluationName: ").append(evaluationName()).append(",");
        }
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (evaluationDataSourceId() != null) {
            sb.append("EvaluationDataSourceId: ").append(evaluationDataSourceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.of(clazz.cast(evaluationId()));
        case "EvaluationName":
            return Optional.of(clazz.cast(evaluationName()));
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        case "EvaluationDataSourceId":
            return Optional.of(clazz.cast(evaluationDataSourceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateEvaluationRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>Evaluation</code>.
         * </p>
         * 
         * @param evaluationId
         *        A user-supplied ID that uniquely identifies the <code>Evaluation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        /**
         * <p>
         * A user-supplied name or description of the <code>Evaluation</code>.
         * </p>
         * 
         * @param evaluationName
         *        A user-supplied name or description of the <code>Evaluation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationName(String evaluationName);

        /**
         * <p>
         * The ID of the <code>MLModel</code> to evaluate.
         * </p>
         * <p>
         * The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code>
         * used in the <code>Evaluation</code>.
         * </p>
         * 
         * @param mlModelId
         *        The ID of the <code>MLModel</code> to evaluate.</p>
         *        <p>
         *        The schema used in creating the <code>MLModel</code> must match the schema of the
         *        <code>DataSource</code> used in the <code>Evaluation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code> must
         * match the schema used to create the <code>MLModel</code>.
         * </p>
         * 
         * @param evaluationDataSourceId
         *        The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code>
         *        must match the schema used to create the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataSourceId(String evaluationDataSourceId);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationId;

        private String evaluationName;

        private String mlModelId;

        private String evaluationDataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationRequest model) {
            evaluationId(model.evaluationId);
            evaluationName(model.evaluationName);
            mlModelId(model.mlModelId);
            evaluationDataSourceId(model.evaluationDataSourceId);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        public final String getEvaluationName() {
            return evaluationName;
        }

        @Override
        public final Builder evaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
            return this;
        }

        public final void setEvaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getEvaluationDataSourceId() {
            return evaluationDataSourceId;
        }

        @Override
        public final Builder evaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
            return this;
        }

        public final void setEvaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
        }

        @Override
        public CreateEvaluationRequest build() {
            return new CreateEvaluationRequest(this);
        }
    }
}
