/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDatabaseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the database details required to connect to an Amazon Redshift database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftDatabase implements StructuredPojo, ToCopyableBuilder<RedshiftDatabase.Builder, RedshiftDatabase> {
    private final String databaseName;

    private final String clusterIdentifier;

    private RedshiftDatabase(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.clusterIdentifier = builder.clusterIdentifier;
    }

    /**
     * Returns the value of the DatabaseName property for this object.
     * 
     * @return The value of the DatabaseName property for this object.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * Returns the value of the ClusterIdentifier property for this object.
     * 
     * @return The value of the ClusterIdentifier property for this object.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDatabase)) {
            return false;
        }
        RedshiftDatabase other = (RedshiftDatabase) obj;
        return Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (databaseName() != null) {
            sb.append("DatabaseName: ").append(databaseName()).append(",");
        }
        if (clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(clusterIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.of(clazz.cast(databaseName()));
        case "ClusterIdentifier":
            return Optional.of(clazz.cast(clusterIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftDatabase> {
        /**
         * Sets the value of the DatabaseName property for this object.
         *
         * @param databaseName
         *        The new value for the DatabaseName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * Sets the value of the ClusterIdentifier property for this object.
         *
         * @param clusterIdentifier
         *        The new value for the ClusterIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String clusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDatabase model) {
            databaseName(model.databaseName);
            clusterIdentifier(model.clusterIdentifier);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public RedshiftDatabase build() {
            return new RedshiftDatabase(this);
        }
    }
}
