/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.machinelearning.model.S3DataSpec;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDataSourceFromS3Request
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromS3Request> {
    private final String dataSourceId;
    private final String dataSourceName;
    private final S3DataSpec dataSpec;
    private final Boolean computeStatistics;

    private CreateDataSourceFromS3Request(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.computeStatistics = builder.computeStatistics;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public S3DataSpec dataSpec() {
        return this.dataSpec;
    }

    public Boolean computeStatistics() {
        return this.computeStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatistics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromS3Request)) {
            return false;
        }
        CreateDataSourceFromS3Request other = (CreateDataSourceFromS3Request)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.dataSpec(), other.dataSpec()) && Objects.equals(this.computeStatistics(), other.computeStatistics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.dataSourceId()).append(",");
        }
        if (this.dataSourceName() != null) {
            sb.append("DataSourceName: ").append(this.dataSourceName()).append(",");
        }
        if (this.dataSpec() != null) {
            sb.append("DataSpec: ").append(this.dataSpec()).append(",");
        }
        if (this.computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(this.computeStatistics()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.of(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.of(clazz.cast(this.dataSourceName()));
            }
            case "DataSpec": {
                return Optional.of(clazz.cast(this.dataSpec()));
            }
            case "ComputeStatistics": {
                return Optional.of(clazz.cast(this.computeStatistics()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private S3DataSpec dataSpec;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromS3Request model) {
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
            this.dataSpec(model.dataSpec);
            this.computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final S3DataSpec.Builder getDataSpec() {
            return this.dataSpec != null ? this.dataSpec.toBuilder() : null;
        }

        @Override
        public final Builder dataSpec(S3DataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(S3DataSpec.BuilderImpl dataSpec) {
            this.dataSpec = dataSpec != null ? dataSpec.build() : null;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        public CreateDataSourceFromS3Request build() {
            return new CreateDataSourceFromS3Request(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDataSourceFromS3Request> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder dataSpec(S3DataSpec var1);

        default public Builder dataSpec(Consumer<S3DataSpec.Builder> dataSpec) {
            return this.dataSpec((S3DataSpec)((S3DataSpec.Builder)S3DataSpec.builder().apply(dataSpec)).build());
        }

        public Builder computeStatistics(Boolean var1);
    }
}

