/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateDataSourceFromRDS</code> operation, and is an acknowledgement that Amazon ML
 * received the request.
 * </p>
 * <p>
 * The <code>CreateDataSourceFromRDS</code>&gt; operation is asynchronous. You can poll for updates by using the
 * <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter. You can inspect the
 * <code>Message</code> when <code>Status</code> shows up as <code>FAILED</code>. You can also check the progress of the
 * copy operation by going to the <code>DataPipeline</code> console and looking up the pipeline using the
 * <code>pipelineId </code> from the describe call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDataSourceFromRDSResponse extends MachineLearningResponse implements
        ToCopyableBuilder<CreateDataSourceFromRDSResponse.Builder, CreateDataSourceFromRDSResponse> {
    private final String dataSourceId;

    private CreateDataSourceFromRDSResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
     * <code>DataSourceID</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value
     *         of the <code>DataSourceID</code> in the request.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRDSResponse)) {
            return false;
        }
        CreateDataSourceFromRDSResponse other = (CreateDataSourceFromRDSResponse) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dataSourceId() != null) {
            sb.append("DataSourceId: ").append(dataSourceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.of(clazz.cast(dataSourceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, CreateDataSourceFromRDSResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of
         * the <code>DataSourceID</code> in the request.
         * </p>
         * 
         * @param dataSourceId
         *        A user-supplied ID that uniquely identifies the datasource. This value should be identical to the
         *        value of the <code>DataSourceID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRDSResponse model) {
            dataSourceId(model.dataSourceId);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public CreateDataSourceFromRDSResponse build() {
            return new CreateDataSourceFromRDSResponse(this);
        }
    }
}
