/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.machinelearning.model.EntityStatus;
import software.amazon.awssdk.services.machinelearning.model.MLModelType;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo;
import software.amazon.awssdk.services.machinelearning.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMLModelResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, GetMLModelResponse> {
    private final String mlModelId;
    private final String trainingDataSourceId;
    private final String createdByIamUser;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String status;
    private final Long sizeInBytes;
    private final RealtimeEndpointInfo endpointInfo;
    private final Map<String, String> trainingParameters;
    private final String inputDataLocationS3;
    private final String mlModelType;
    private final Float scoreThreshold;
    private final Instant scoreThresholdLastUpdatedAt;
    private final String logUri;
    private final String message;
    private final Long computeTime;
    private final Instant finishedAt;
    private final Instant startedAt;
    private final String recipe;
    private final String schema;

    private GetMLModelResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.sizeInBytes = builder.sizeInBytes;
        this.endpointInfo = builder.endpointInfo;
        this.trainingParameters = builder.trainingParameters;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.mlModelType = builder.mlModelType;
        this.scoreThreshold = builder.scoreThreshold;
        this.scoreThresholdLastUpdatedAt = builder.scoreThresholdLastUpdatedAt;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.recipe = builder.recipe;
        this.schema = builder.schema;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String trainingDataSourceId() {
        return this.trainingDataSourceId;
    }

    public String createdByIamUser() {
        return this.createdByIamUser;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String name() {
        return this.name;
    }

    public EntityStatus status() {
        return EntityStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public RealtimeEndpointInfo endpointInfo() {
        return this.endpointInfo;
    }

    public Map<String, String> trainingParameters() {
        return this.trainingParameters;
    }

    public String inputDataLocationS3() {
        return this.inputDataLocationS3;
    }

    public MLModelType mlModelType() {
        return MLModelType.fromValue(this.mlModelType);
    }

    public String mlModelTypeString() {
        return this.mlModelType;
    }

    public Float scoreThreshold() {
        return this.scoreThreshold;
    }

    public Instant scoreThresholdLastUpdatedAt() {
        return this.scoreThresholdLastUpdatedAt;
    }

    public String logUri() {
        return this.logUri;
    }

    public String message() {
        return this.message;
    }

    public Long computeTime() {
        return this.computeTime;
    }

    public Instant finishedAt() {
        return this.finishedAt;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public String recipe() {
        return this.recipe;
    }

    public String schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreThresholdLastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMLModelResponse)) {
            return false;
        }
        GetMLModelResponse other = (GetMLModelResponse)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.trainingDataSourceId(), other.trainingDataSourceId()) && Objects.equals(this.createdByIamUser(), other.createdByIamUser()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.endpointInfo(), other.endpointInfo()) && Objects.equals(this.trainingParameters(), other.trainingParameters()) && Objects.equals(this.inputDataLocationS3(), other.inputDataLocationS3()) && Objects.equals(this.mlModelTypeString(), other.mlModelTypeString()) && Objects.equals(this.scoreThreshold(), other.scoreThreshold()) && Objects.equals(this.scoreThresholdLastUpdatedAt(), other.scoreThresholdLastUpdatedAt()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.computeTime(), other.computeTime()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.recipe(), other.recipe()) && Objects.equals(this.schema(), other.schema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.trainingDataSourceId() != null) {
            sb.append("TrainingDataSourceId: ").append(this.trainingDataSourceId()).append(",");
        }
        if (this.createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(this.createdByIamUser()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.lastUpdatedAt()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.sizeInBytes() != null) {
            sb.append("SizeInBytes: ").append(this.sizeInBytes()).append(",");
        }
        if (this.endpointInfo() != null) {
            sb.append("EndpointInfo: ").append(this.endpointInfo()).append(",");
        }
        if (this.trainingParameters() != null) {
            sb.append("TrainingParameters: ").append(this.trainingParameters()).append(",");
        }
        if (this.inputDataLocationS3() != null) {
            sb.append("InputDataLocationS3: ").append(this.inputDataLocationS3()).append(",");
        }
        if (this.mlModelTypeString() != null) {
            sb.append("MLModelType: ").append(this.mlModelTypeString()).append(",");
        }
        if (this.scoreThreshold() != null) {
            sb.append("ScoreThreshold: ").append(this.scoreThreshold()).append(",");
        }
        if (this.scoreThresholdLastUpdatedAt() != null) {
            sb.append("ScoreThresholdLastUpdatedAt: ").append(this.scoreThresholdLastUpdatedAt()).append(",");
        }
        if (this.logUri() != null) {
            sb.append("LogUri: ").append(this.logUri()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.computeTime() != null) {
            sb.append("ComputeTime: ").append(this.computeTime()).append(",");
        }
        if (this.finishedAt() != null) {
            sb.append("FinishedAt: ").append(this.finishedAt()).append(",");
        }
        if (this.startedAt() != null) {
            sb.append("StartedAt: ").append(this.startedAt()).append(",");
        }
        if (this.recipe() != null) {
            sb.append("Recipe: ").append(this.recipe()).append(",");
        }
        if (this.schema() != null) {
            sb.append("Schema: ").append(this.schema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "TrainingDataSourceId": {
                return Optional.of(clazz.cast(this.trainingDataSourceId()));
            }
            case "CreatedByIamUser": {
                return Optional.of(clazz.cast(this.createdByIamUser()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.of(clazz.cast(this.lastUpdatedAt()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "SizeInBytes": {
                return Optional.of(clazz.cast(this.sizeInBytes()));
            }
            case "EndpointInfo": {
                return Optional.of(clazz.cast(this.endpointInfo()));
            }
            case "TrainingParameters": {
                return Optional.of(clazz.cast(this.trainingParameters()));
            }
            case "InputDataLocationS3": {
                return Optional.of(clazz.cast(this.inputDataLocationS3()));
            }
            case "MLModelType": {
                return Optional.of(clazz.cast(this.mlModelTypeString()));
            }
            case "ScoreThreshold": {
                return Optional.of(clazz.cast(this.scoreThreshold()));
            }
            case "ScoreThresholdLastUpdatedAt": {
                return Optional.of(clazz.cast(this.scoreThresholdLastUpdatedAt()));
            }
            case "LogUri": {
                return Optional.of(clazz.cast(this.logUri()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "ComputeTime": {
                return Optional.of(clazz.cast(this.computeTime()));
            }
            case "FinishedAt": {
                return Optional.of(clazz.cast(this.finishedAt()));
            }
            case "StartedAt": {
                return Optional.of(clazz.cast(this.startedAt()));
            }
            case "Recipe": {
                return Optional.of(clazz.cast(this.recipe()));
            }
            case "Schema": {
                return Optional.of(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String mlModelId;
        private String trainingDataSourceId;
        private String createdByIamUser;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String name;
        private String status;
        private Long sizeInBytes;
        private RealtimeEndpointInfo endpointInfo;
        private Map<String, String> trainingParameters;
        private String inputDataLocationS3;
        private String mlModelType;
        private Float scoreThreshold;
        private Instant scoreThresholdLastUpdatedAt;
        private String logUri;
        private String message;
        private Long computeTime;
        private Instant finishedAt;
        private Instant startedAt;
        private String recipe;
        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMLModelResponse model) {
            this.mlModelId(model.mlModelId);
            this.trainingDataSourceId(model.trainingDataSourceId);
            this.createdByIamUser(model.createdByIamUser);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.status(model.status);
            this.sizeInBytes(model.sizeInBytes);
            this.endpointInfo(model.endpointInfo);
            this.trainingParameters(model.trainingParameters);
            this.inputDataLocationS3(model.inputDataLocationS3);
            this.mlModelType(model.mlModelType);
            this.scoreThreshold(model.scoreThreshold);
            this.scoreThresholdLastUpdatedAt(model.scoreThresholdLastUpdatedAt);
            this.logUri(model.logUri);
            this.message(model.message);
            this.computeTime(model.computeTime);
            this.finishedAt(model.finishedAt);
            this.startedAt(model.startedAt);
            this.recipe(model.recipe);
            this.schema(model.schema);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getTrainingDataSourceId() {
            return this.trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getCreatedByIamUser() {
            return this.createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final RealtimeEndpointInfo.Builder getEndpointInfo() {
            return this.endpointInfo != null ? this.endpointInfo.toBuilder() : null;
        }

        @Override
        public final Builder endpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final void setEndpointInfo(RealtimeEndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        public final Map<String, String> getTrainingParameters() {
            return this.trainingParameters;
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        public final String getInputDataLocationS3() {
            return this.inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getMLModelType() {
            return this.mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
            return this;
        }

        public final void setMLModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final Float getScoreThreshold() {
            return this.scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public final Instant getScoreThresholdLastUpdatedAt() {
            return this.scoreThresholdLastUpdatedAt;
        }

        @Override
        public final Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
            return this;
        }

        public final void setScoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return this.computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final String getRecipe() {
            return this.recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        public final String getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public GetMLModelResponse build() {
            return new GetMLModelResponse(this);
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    CopyableBuilder<Builder, GetMLModelResponse> {
        public Builder mlModelId(String var1);

        public Builder trainingDataSourceId(String var1);

        public Builder createdByIamUser(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EntityStatus var1);

        public Builder sizeInBytes(Long var1);

        public Builder endpointInfo(RealtimeEndpointInfo var1);

        default public Builder endpointInfo(Consumer<RealtimeEndpointInfo.Builder> endpointInfo) {
            return this.endpointInfo((RealtimeEndpointInfo)((RealtimeEndpointInfo.Builder)RealtimeEndpointInfo.builder().apply(endpointInfo)).build());
        }

        public Builder trainingParameters(Map<String, String> var1);

        public Builder inputDataLocationS3(String var1);

        public Builder mlModelType(String var1);

        public Builder mlModelType(MLModelType var1);

        public Builder scoreThreshold(Float var1);

        public Builder scoreThresholdLastUpdatedAt(Instant var1);

        public Builder logUri(String var1);

        public Builder message(String var1);

        public Builder computeTime(Long var1);

        public Builder finishedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder recipe(String var1);

        public Builder schema(String var1);
    }
}

