/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDataSpecMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDataSpec
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftDataSpec> {
    private final RedshiftDatabase databaseInformation;
    private final String selectSqlQuery;
    private final RedshiftDatabaseCredentials databaseCredentials;
    private final String s3StagingLocation;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaUri;

    private RedshiftDataSpec(BuilderImpl builder) {
        this.databaseInformation = builder.databaseInformation;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.databaseCredentials = builder.databaseCredentials;
        this.s3StagingLocation = builder.s3StagingLocation;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaUri = builder.dataSchemaUri;
    }

    public RedshiftDatabase databaseInformation() {
        return this.databaseInformation;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public RedshiftDatabaseCredentials databaseCredentials() {
        return this.databaseCredentials;
    }

    public String s3StagingLocation() {
        return this.s3StagingLocation;
    }

    public String dataRearrangement() {
        return this.dataRearrangement;
    }

    public String dataSchema() {
        return this.dataSchema;
    }

    public String dataSchemaUri() {
        return this.dataSchemaUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StagingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRearrangement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchemaUri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataSpec)) {
            return false;
        }
        RedshiftDataSpec other = (RedshiftDataSpec)obj;
        return Objects.equals(this.databaseInformation(), other.databaseInformation()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery()) && Objects.equals(this.databaseCredentials(), other.databaseCredentials()) && Objects.equals(this.s3StagingLocation(), other.s3StagingLocation()) && Objects.equals(this.dataRearrangement(), other.dataRearrangement()) && Objects.equals(this.dataSchema(), other.dataSchema()) && Objects.equals(this.dataSchemaUri(), other.dataSchemaUri());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.databaseInformation() != null) {
            sb.append("DatabaseInformation: ").append(this.databaseInformation()).append(",");
        }
        if (this.selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.selectSqlQuery()).append(",");
        }
        if (this.databaseCredentials() != null) {
            sb.append("DatabaseCredentials: ").append(this.databaseCredentials()).append(",");
        }
        if (this.s3StagingLocation() != null) {
            sb.append("S3StagingLocation: ").append(this.s3StagingLocation()).append(",");
        }
        if (this.dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(this.dataRearrangement()).append(",");
        }
        if (this.dataSchema() != null) {
            sb.append("DataSchema: ").append(this.dataSchema()).append(",");
        }
        if (this.dataSchemaUri() != null) {
            sb.append("DataSchemaUri: ").append(this.dataSchemaUri()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseInformation": {
                return Optional.of(clazz.cast(this.databaseInformation()));
            }
            case "SelectSqlQuery": {
                return Optional.of(clazz.cast(this.selectSqlQuery()));
            }
            case "DatabaseCredentials": {
                return Optional.of(clazz.cast(this.databaseCredentials()));
            }
            case "S3StagingLocation": {
                return Optional.of(clazz.cast(this.s3StagingLocation()));
            }
            case "DataRearrangement": {
                return Optional.of(clazz.cast(this.dataRearrangement()));
            }
            case "DataSchema": {
                return Optional.of(clazz.cast(this.dataSchema()));
            }
            case "DataSchemaUri": {
                return Optional.of(clazz.cast(this.dataSchemaUri()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDataSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftDatabase databaseInformation;
        private String selectSqlQuery;
        private RedshiftDatabaseCredentials databaseCredentials;
        private String s3StagingLocation;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaUri;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataSpec model) {
            this.databaseInformation(model.databaseInformation);
            this.selectSqlQuery(model.selectSqlQuery);
            this.databaseCredentials(model.databaseCredentials);
            this.s3StagingLocation(model.s3StagingLocation);
            this.dataRearrangement(model.dataRearrangement);
            this.dataSchema(model.dataSchema);
            this.dataSchemaUri(model.dataSchemaUri);
        }

        public final RedshiftDatabase.Builder getDatabaseInformation() {
            return this.databaseInformation != null ? this.databaseInformation.toBuilder() : null;
        }

        @Override
        public final Builder databaseInformation(RedshiftDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
            return this;
        }

        public final void setDatabaseInformation(RedshiftDatabase.BuilderImpl databaseInformation) {
            this.databaseInformation = databaseInformation != null ? databaseInformation.build() : null;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final RedshiftDatabaseCredentials.Builder getDatabaseCredentials() {
            return this.databaseCredentials != null ? this.databaseCredentials.toBuilder() : null;
        }

        @Override
        public final Builder databaseCredentials(RedshiftDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
            return this;
        }

        public final void setDatabaseCredentials(RedshiftDatabaseCredentials.BuilderImpl databaseCredentials) {
            this.databaseCredentials = databaseCredentials != null ? databaseCredentials.build() : null;
        }

        public final String getS3StagingLocation() {
            return this.s3StagingLocation;
        }

        @Override
        public final Builder s3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
            return this;
        }

        public final void setS3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        public final String getDataSchemaUri() {
            return this.dataSchemaUri;
        }

        @Override
        public final Builder dataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
            return this;
        }

        public final void setDataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
        }

        public RedshiftDataSpec build() {
            return new RedshiftDataSpec(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftDataSpec> {
        public Builder databaseInformation(RedshiftDatabase var1);

        default public Builder databaseInformation(Consumer<RedshiftDatabase.Builder> databaseInformation) {
            return this.databaseInformation((RedshiftDatabase)((RedshiftDatabase.Builder)RedshiftDatabase.builder().apply(databaseInformation)).build());
        }

        public Builder selectSqlQuery(String var1);

        public Builder databaseCredentials(RedshiftDatabaseCredentials var1);

        default public Builder databaseCredentials(Consumer<RedshiftDatabaseCredentials.Builder> databaseCredentials) {
            return this.databaseCredentials((RedshiftDatabaseCredentials)((RedshiftDatabaseCredentials.Builder)RedshiftDatabaseCredentials.builder().apply(databaseCredentials)).build());
        }

        public Builder s3StagingLocation(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaUri(String var1);
    }
}

