/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDatabaseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDatabase
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftDatabase> {
    private final String databaseName;
    private final String clusterIdentifier;

    private RedshiftDatabase(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.clusterIdentifier = builder.clusterIdentifier;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDatabase)) {
            return false;
        }
        RedshiftDatabase other = (RedshiftDatabase)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.databaseName() != null) {
            sb.append("DatabaseName: ").append(this.databaseName()).append(",");
        }
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String clusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDatabase model) {
            this.databaseName(model.databaseName);
            this.clusterIdentifier(model.clusterIdentifier);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public RedshiftDatabase build() {
            return new RedshiftDatabase(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftDatabase> {
        public Builder databaseName(String var1);

        public Builder clusterIdentifier(String var1);
    }
}

