/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdateDataSource</code> operation.
 * </p>
 * <p>
 * You can see the updated content by using the <code>GetBatchPrediction</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDataSourceResponse extends MachineLearningResponse implements
        ToCopyableBuilder<UpdateDataSourceResponse.Builder, UpdateDataSourceResponse> {
    private final String dataSourceId;

    private UpdateDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
    }

    /**
     * <p>
     * The ID assigned to the <code>DataSource</code> during creation. This value should be identical to the value of
     * the <code>DataSourceID</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>DataSource</code> during creation. This value should be identical to the
     *         value of the <code>DataSourceID</code> in the request.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceResponse)) {
            return false;
        }
        UpdateDataSourceResponse other = (UpdateDataSourceResponse) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDataSourceResponse").add("DataSourceId", dataSourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.of(clazz.cast(dataSourceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, UpdateDataSourceResponse> {
        /**
         * <p>
         * The ID assigned to the <code>DataSource</code> during creation. This value should be identical to the value
         * of the <code>DataSourceID</code> in the request.
         * </p>
         * 
         * @param dataSourceId
         *        The ID assigned to the <code>DataSource</code> during creation. This value should be identical to the
         *        value of the <code>DataSourceID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceResponse model) {
            dataSourceId(model.dataSourceId);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public UpdateDataSourceResponse build() {
            return new UpdateDataSourceResponse(this);
        }
    }
}
