/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.TagMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom key-value pair associated with an ML object, such as an ML model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Tag implements StructuredPojo, ToCopyableBuilder<Tag.Builder, Tag> {
    private final String key;

    private final String value;

    private Tag(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * A unique identifier for the tag. Valid characters include Unicode letters, digits, white space, _, ., /, =, +, -,
     * %, and @.
     * </p>
     * 
     * @return A unique identifier for the tag. Valid characters include Unicode letters, digits, white space, _, ., /,
     *         =, +, -, %, and @.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * An optional string, typically used to describe or define the tag. Valid characters include Unicode letters,
     * digits, white space, _, ., /, =, +, -, %, and @.
     * </p>
     * 
     * @return An optional string, typically used to describe or define the tag. Valid characters include Unicode
     *         letters, digits, white space, _, ., /, =, +, -, %, and @.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("Tag").add("Key", key()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Tag> {
        /**
         * <p>
         * A unique identifier for the tag. Valid characters include Unicode letters, digits, white space, _, ., /, =,
         * +, -, %, and @.
         * </p>
         * 
         * @param key
         *        A unique identifier for the tag. Valid characters include Unicode letters, digits, white space, _, .,
         *        /, =, +, -, %, and @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * An optional string, typically used to describe or define the tag. Valid characters include Unicode letters,
         * digits, white space, _, ., /, =, +, -, %, and @.
         * </p>
         * 
         * @param value
         *        An optional string, typically used to describe or define the tag. Valid characters include Unicode
         *        letters, digits, white space, _, ., /, =, +, -, %, and @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Tag build() {
            return new Tag(this);
        }
    }
}
