/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.machinelearning.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetBatchPredictionResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetBatchPredictionResponseUnmarshaller implements Unmarshaller<GetBatchPredictionResponse, JsonUnmarshallerContext> {

    public GetBatchPredictionResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetBatchPredictionResponse.Builder getBatchPredictionResponseBuilder = GetBatchPredictionResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getBatchPredictionResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("BatchPredictionId", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder
                            .batchPredictionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MLModelId", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.mlModelId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BatchPredictionDataSourceId", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.batchPredictionDataSourceId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("InputDataLocationS3", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.inputDataLocationS3(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("CreatedByIamUser", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.createdByIamUser(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("LastUpdatedAt", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.lastUpdatedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OutputUri", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.outputUri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LogUri", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.logUri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Message", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.message(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComputeTime", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.computeTime(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("FinishedAt", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.finishedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("StartedAt", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.startedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("TotalRecordCount", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.totalRecordCount(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("InvalidRecordCount", targetDepth)) {
                    context.nextToken();
                    getBatchPredictionResponseBuilder.invalidRecordCount(context.getUnmarshaller(Long.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getBatchPredictionResponseBuilder.build();
    }

    private static final GetBatchPredictionResponseUnmarshaller INSTANCE = new GetBatchPredictionResponseUnmarshaller();

    public static GetBatchPredictionResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
