/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.machinelearning.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MLModel JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MLModelUnmarshaller implements Unmarshaller<MLModel, JsonUnmarshallerContext> {

    public MLModel unmarshall(JsonUnmarshallerContext context) throws Exception {
        MLModel.Builder mlModelBuilder = MLModel.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("MLModelId", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.mlModelId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TrainingDataSourceId", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.trainingDataSourceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedByIamUser", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.createdByIamUser(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("LastUpdatedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.lastUpdatedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SizeInBytes", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.sizeInBytes(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("EndpointInfo", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.endpointInfo(RealtimeEndpointInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TrainingParameters", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.trainingParameters(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("InputDataLocationS3", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.inputDataLocationS3(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Algorithm", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.algorithm(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MLModelType", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.mlModelType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ScoreThreshold", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.scoreThreshold(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("ScoreThresholdLastUpdatedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.scoreThresholdLastUpdatedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("Message", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.message(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComputeTime", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.computeTime(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("FinishedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.finishedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("StartedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.startedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return mlModelBuilder.build();
    }

    private static final MLModelUnmarshaller INSTANCE = new MLModelUnmarshaller();

    public static MLModelUnmarshaller getInstance() {
        return INSTANCE;
    }
}
