/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RDSDataSpec;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RDSDataSpec} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RDSDataSpecMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATABASEINFORMATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DatabaseInformation").isBinary(false).build();

    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DATABASECREDENTIALS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DatabaseCredentials").isBinary(false).build();

    private static final MarshallingInfo<String> S3STAGINGLOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3StagingLocation").isBinary(false).build();

    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").isBinary(false).build();

    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").isBinary(false).build();

    private static final MarshallingInfo<String> DATASCHEMAURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaUri").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCEROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceRole").isBinary(false).build();

    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").isBinary(false).build();

    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();

    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").isBinary(false).build();

    private static final RDSDataSpecMarshaller INSTANCE = new RDSDataSpecMarshaller();

    private RDSDataSpecMarshaller() {
    }

    public static RDSDataSpecMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RDSDataSpec rdsDataSpec, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(rdsDataSpec, "rdsDataSpec");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(rdsDataSpec.databaseInformation(), DATABASEINFORMATION_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.selectSqlQuery(), SELECTSQLQUERY_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.databaseCredentials(), DATABASECREDENTIALS_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.s3StagingLocation(), S3STAGINGLOCATION_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.dataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.dataSchemaUri(), DATASCHEMAURI_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.resourceRole(), RESOURCEROLE_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.securityGroupIds(), SECURITYGROUPIDS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
