/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddTagsRequest extends MachineLearningRequest implements
        ToCopyableBuilder<AddTagsRequest.Builder, AddTagsRequest> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(AddTagsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddTagsRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddTagsRequest::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD));

    private final List<Tag> tags;

    private final String resourceId;

    private final String resourceType;

    private AddTagsRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a
     * tag with the specified key and a value of null.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML
     *         creates a tag with the specified key and a value of null.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the ML object to tag. For example, <code>exampleModelId</code>.
     * </p>
     * 
     * @return The ID of the ML object to tag. For example, <code>exampleModelId</code>.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the ML object to tag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the ML object to tag.
     * @see TaggableResourceType
     */
    public TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the ML object to tag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the ML object to tag.
     * @see TaggableResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest) obj;
        return Objects.equals(tags(), other.tags()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddTagsRequest").add("Tags", tags()).add("ResourceId", resourceId())
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddTagsRequest, T> g) {
        return obj -> g.apply((AddTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddTagsRequest> {
        /**
         * <p>
         * The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates
         * a tag with the specified key and a value of null.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML
         *        creates a tag with the specified key and a value of null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates
         * a tag with the specified key and a value of null.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML
         *        creates a tag with the specified key and a value of null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates
         * a tag with the specified key and a value of null.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the ML object to tag. For example, <code>exampleModelId</code>.
         * </p>
         * 
         * @param resourceId
         *        The ID of the ML object to tag. For example, <code>exampleModelId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the ML object to tag.
         * </p>
         * 
         * @param resourceType
         *        The type of the ML object to tag.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the ML object to tag.
         * </p>
         * 
         * @param resourceType
         *        The type of the ML object to tag.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(TaggableResourceType resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsRequest model) {
            super(model);
            tags(model.tags);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddTagsRequest build() {
            return new AddTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
