/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the real-time endpoint information for an <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealtimeEndpointInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<RealtimeEndpointInfo.Builder, RealtimeEndpointInfo> {
    private static final SdkField<Integer> PEAK_REQUESTS_PER_SECOND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeakRequestsPerSecond").getter(getter(RealtimeEndpointInfo::peakRequestsPerSecond))
            .setter(setter(Builder::peakRequestsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeakRequestsPerSecond").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(RealtimeEndpointInfo::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointUrl").getter(getter(RealtimeEndpointInfo::endpointUrl)).setter(setter(Builder::endpointUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()).build();

    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointStatus").getter(getter(RealtimeEndpointInfo::endpointStatusAsString))
            .setter(setter(Builder::endpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PEAK_REQUESTS_PER_SECOND_FIELD, CREATED_AT_FIELD, ENDPOINT_URL_FIELD, ENDPOINT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer peakRequestsPerSecond;

    private final Instant createdAt;

    private final String endpointUrl;

    private final String endpointStatus;

    private RealtimeEndpointInfo(BuilderImpl builder) {
        this.peakRequestsPerSecond = builder.peakRequestsPerSecond;
        this.createdAt = builder.createdAt;
        this.endpointUrl = builder.endpointUrl;
        this.endpointStatus = builder.endpointStatus;
    }

    /**
     * <p>
     * The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming requests
     * per second.
     * </p>
     * 
     * @return The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming
     *         requests per second.
     */
    public Integer peakRequestsPerSecond() {
        return peakRequestsPerSecond;
    }

    /**
     * <p>
     * The time that the request to create the real-time endpoint for the <code>MLModel</code> was received. The time is
     * expressed in epoch time.
     * </p>
     * 
     * @return The time that the request to create the real-time endpoint for the <code>MLModel</code> was received. The
     *         time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.
     * </p>
     * <note><title>Note</title>
     * <p>
     * The application must wait until the real-time endpoint is ready before using this URI.
     * </p>
     * </note>
     * 
     * @return The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.</p>
     *         <note><title>Note</title>
     *         <p>
     *         The application must wait until the real-time endpoint is ready before using this URI.
     *         </p>
     */
    public String endpointUrl() {
        return endpointUrl;
    }

    /**
     * <p>
     * The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the
     * following values:
     * </p>
     * <ul>
     * <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
     * <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
     * <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link RealtimeEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of
     *         the following values: </p>
     *         <ul>
     *         <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
     *         <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
     *         <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
     * @see RealtimeEndpointStatus
     */
    public RealtimeEndpointStatus endpointStatus() {
        return RealtimeEndpointStatus.fromValue(endpointStatus);
    }

    /**
     * <p>
     * The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the
     * following values:
     * </p>
     * <ul>
     * <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
     * <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
     * <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link RealtimeEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of
     *         the following values: </p>
     *         <ul>
     *         <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
     *         <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
     *         <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
     * @see RealtimeEndpointStatus
     */
    public String endpointStatusAsString() {
        return endpointStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peakRequestsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeEndpointInfo)) {
            return false;
        }
        RealtimeEndpointInfo other = (RealtimeEndpointInfo) obj;
        return Objects.equals(peakRequestsPerSecond(), other.peakRequestsPerSecond())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(endpointUrl(), other.endpointUrl())
                && Objects.equals(endpointStatusAsString(), other.endpointStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RealtimeEndpointInfo").add("PeakRequestsPerSecond", peakRequestsPerSecond())
                .add("CreatedAt", createdAt()).add("EndpointUrl", endpointUrl()).add("EndpointStatus", endpointStatusAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeakRequestsPerSecond":
            return Optional.ofNullable(clazz.cast(peakRequestsPerSecond()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "EndpointUrl":
            return Optional.ofNullable(clazz.cast(endpointUrl()));
        case "EndpointStatus":
            return Optional.ofNullable(clazz.cast(endpointStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealtimeEndpointInfo, T> g) {
        return obj -> g.apply((RealtimeEndpointInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealtimeEndpointInfo> {
        /**
         * <p>
         * The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming
         * requests per second.
         * </p>
         * 
         * @param peakRequestsPerSecond
         *        The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming
         *        requests per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peakRequestsPerSecond(Integer peakRequestsPerSecond);

        /**
         * <p>
         * The time that the request to create the real-time endpoint for the <code>MLModel</code> was received. The
         * time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the request to create the real-time endpoint for the <code>MLModel</code> was received.
         *        The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.
         * </p>
         * <note><title>Note</title>
         * <p>
         * The application must wait until the real-time endpoint is ready before using this URI.
         * </p>
         * </note>
         * 
         * @param endpointUrl
         *        The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.</p>
         *        <note><title>Note</title>
         *        <p>
         *        The application must wait until the real-time endpoint is ready before using this URI.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointUrl(String endpointUrl);

        /**
         * <p>
         * The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the
         * following values:
         * </p>
         * <ul>
         * <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         * <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         * <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * </ul>
         * 
         * @param endpointStatus
         *        The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one
         *        of the following values: </p>
         *        <ul>
         *        <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         *        <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         *        <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * @see RealtimeEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealtimeEndpointStatus
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the
         * following values:
         * </p>
         * <ul>
         * <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         * <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         * <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * </ul>
         * 
         * @param endpointStatus
         *        The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one
         *        of the following values: </p>
         *        <ul>
         *        <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li>
         *        <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li>
         *        <li> <code>UPDATING</code> - Updating/creating the endpoint.</li>
         * @see RealtimeEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealtimeEndpointStatus
         */
        Builder endpointStatus(RealtimeEndpointStatus endpointStatus);
    }

    static final class BuilderImpl implements Builder {
        private Integer peakRequestsPerSecond;

        private Instant createdAt;

        private String endpointUrl;

        private String endpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeEndpointInfo model) {
            peakRequestsPerSecond(model.peakRequestsPerSecond);
            createdAt(model.createdAt);
            endpointUrl(model.endpointUrl);
            endpointStatus(model.endpointStatus);
        }

        public final Integer getPeakRequestsPerSecond() {
            return peakRequestsPerSecond;
        }

        @Override
        public final Builder peakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
            return this;
        }

        public final void setPeakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getEndpointUrl() {
            return endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(RealtimeEndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public RealtimeEndpointInfo build() {
            return new RealtimeEndpointInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
