/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictRequest extends MachineLearningRequest implements
        ToCopyableBuilder<PredictRequest.Builder, PredictRequest> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelId").getter(getter(PredictRequest::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final SdkField<Map<String, String>> RECORD_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Record")
            .getter(getter(PredictRequest::record))
            .setter(setter(Builder::record))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PREDICT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictEndpoint").getter(getter(PredictRequest::predictEndpoint))
            .setter(setter(Builder::predictEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD,
            RECORD_FIELD, PREDICT_ENDPOINT_FIELD));

    private final String mlModelId;

    private final Map<String, String> record;

    private final String predictEndpoint;

    private PredictRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.record = builder.record;
        this.predictEndpoint = builder.predictEndpoint;
    }

    /**
     * <p>
     * A unique identifier of the <code>MLModel</code>.
     * </p>
     * 
     * @return A unique identifier of the <code>MLModel</code>.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * Returns true if the Record property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecord() {
        return record != null && !(record instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Record property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecord()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Record property for this object.
     */
    public Map<String, String> record() {
        return record;
    }

    /**
     * Returns the value of the PredictEndpoint property for this object.
     * 
     * @return The value of the PredictEndpoint property for this object.
     */
    public String predictEndpoint() {
        return predictEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecord() ? record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(predictEndpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictRequest)) {
            return false;
        }
        PredictRequest other = (PredictRequest) obj;
        return Objects.equals(mlModelId(), other.mlModelId()) && hasRecord() == other.hasRecord()
                && Objects.equals(record(), other.record()) && Objects.equals(predictEndpoint(), other.predictEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PredictRequest").add("MLModelId", mlModelId()).add("Record", hasRecord() ? record() : null)
                .add("PredictEndpoint", predictEndpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "Record":
            return Optional.ofNullable(clazz.cast(record()));
        case "PredictEndpoint":
            return Optional.ofNullable(clazz.cast(predictEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictRequest, T> g) {
        return obj -> g.apply((PredictRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo, CopyableBuilder<Builder, PredictRequest> {
        /**
         * <p>
         * A unique identifier of the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelId
         *        A unique identifier of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * Sets the value of the Record property for this object.
         *
         * @param record
         *        The new value for the Record property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Map<String, String> record);

        /**
         * Sets the value of the PredictEndpoint property for this object.
         *
         * @param predictEndpoint
         *        The new value for the PredictEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictEndpoint(String predictEndpoint);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String mlModelId;

        private Map<String, String> record = DefaultSdkAutoConstructMap.getInstance();

        private String predictEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictRequest model) {
            super(model);
            mlModelId(model.mlModelId);
            record(model.record);
            predictEndpoint(model.predictEndpoint);
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final Map<String, String> getRecord() {
            if (record instanceof SdkAutoConstructMap) {
                return null;
            }
            return record;
        }

        @Override
        public final Builder record(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        public final void setRecord(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
        }

        public final String getPredictEndpoint() {
            return predictEndpoint;
        }

        @Override
        public final Builder predictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
            return this;
        }

        public final void setPredictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PredictRequest build() {
            return new PredictRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
