/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetMLModel</code> operation.
 * </p>
 * <p>
 * The content consists of the detailed metadata and the current status of the <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MLModel implements SdkPojo, Serializable, ToCopyableBuilder<MLModel.Builder, MLModel> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelId").getter(getter(MLModel::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final SdkField<String> TRAINING_DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingDataSourceId").getter(getter(MLModel::trainingDataSourceId))
            .setter(setter(Builder::trainingDataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataSourceId").build())
            .build();

    private static final SdkField<String> CREATED_BY_IAM_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByIamUser").getter(getter(MLModel::createdByIamUser)).setter(setter(Builder::createdByIamUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByIamUser").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(MLModel::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(MLModel::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MLModel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MLModel::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SizeInBytes").getter(getter(MLModel::sizeInBytes)).setter(setter(Builder::sizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()).build();

    private static final SdkField<RealtimeEndpointInfo> ENDPOINT_INFO_FIELD = SdkField
            .<RealtimeEndpointInfo> builder(MarshallingType.SDK_POJO).memberName("EndpointInfo")
            .getter(getter(MLModel::endpointInfo)).setter(setter(Builder::endpointInfo))
            .constructor(RealtimeEndpointInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInfo").build()).build();

    private static final SdkField<Map<String, String>> TRAINING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TrainingParameters")
            .getter(getter(MLModel::trainingParameters))
            .setter(setter(Builder::trainingParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INPUT_DATA_LOCATION_S3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputDataLocationS3").getter(getter(MLModel::inputDataLocationS3))
            .setter(setter(Builder::inputDataLocationS3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataLocationS3").build())
            .build();

    private static final SdkField<String> ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Algorithm").getter(getter(MLModel::algorithmAsString)).setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()).build();

    private static final SdkField<String> ML_MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelType").getter(getter(MLModel::mlModelTypeAsString)).setter(setter(Builder::mlModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelType").build()).build();

    private static final SdkField<Float> SCORE_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ScoreThreshold").getter(getter(MLModel::scoreThreshold)).setter(setter(Builder::scoreThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreThreshold").build()).build();

    private static final SdkField<Instant> SCORE_THRESHOLD_LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScoreThresholdLastUpdatedAt")
            .getter(getter(MLModel::scoreThresholdLastUpdatedAt))
            .setter(setter(Builder::scoreThresholdLastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreThresholdLastUpdatedAt")
                    .build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(MLModel::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Long> COMPUTE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ComputeTime").getter(getter(MLModel::computeTime)).setter(setter(Builder::computeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTime").build()).build();

    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FinishedAt").getter(getter(MLModel::finishedAt)).setter(setter(Builder::finishedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(MLModel::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD,
            TRAINING_DATA_SOURCE_ID_FIELD, CREATED_BY_IAM_USER_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD,
            STATUS_FIELD, SIZE_IN_BYTES_FIELD, ENDPOINT_INFO_FIELD, TRAINING_PARAMETERS_FIELD, INPUT_DATA_LOCATION_S3_FIELD,
            ALGORITHM_FIELD, ML_MODEL_TYPE_FIELD, SCORE_THRESHOLD_FIELD, SCORE_THRESHOLD_LAST_UPDATED_AT_FIELD, MESSAGE_FIELD,
            COMPUTE_TIME_FIELD, FINISHED_AT_FIELD, STARTED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mlModelId;

    private final String trainingDataSourceId;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String status;

    private final Long sizeInBytes;

    private final RealtimeEndpointInfo endpointInfo;

    private final Map<String, String> trainingParameters;

    private final String inputDataLocationS3;

    private final String algorithm;

    private final String mlModelType;

    private final Float scoreThreshold;

    private final Instant scoreThresholdLastUpdatedAt;

    private final String message;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private MLModel(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.sizeInBytes = builder.sizeInBytes;
        this.endpointInfo = builder.endpointInfo;
        this.trainingParameters = builder.trainingParameters;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.algorithm = builder.algorithm;
        this.mlModelType = builder.mlModelType;
        this.scoreThreshold = builder.scoreThreshold;
        this.scoreThresholdLastUpdatedAt = builder.scoreThresholdLastUpdatedAt;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> at creation.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> at creation.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
     * <code>TrainingDataSourceId</code>.
     * </p>
     * 
     * @return The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
     *         <code>TrainingDataSourceId</code>.
     */
    public String trainingDataSourceId() {
        return trainingDataSourceId;
    }

    /**
     * <p>
     * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root
     * account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account from which the <code>MLModel</code> was created. The account type can be either an
     *         AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of an <code>MLModel</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
     * <code>MLModel</code>.</li>
     * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     * <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The model isn't
     * usable.</li>
     * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of an <code>MLModel</code>. This element can have one of the following values: </p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
     *         <code>MLModel</code>.</li>
     *         <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     *         <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The
     *         model isn't usable.</li>
     *         <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * @see EntityStatus
     */
    public EntityStatus status() {
        return EntityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of an <code>MLModel</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
     * <code>MLModel</code>.</li>
     * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     * <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The model isn't
     * usable.</li>
     * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of an <code>MLModel</code>. This element can have one of the following values: </p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
     *         <code>MLModel</code>.</li>
     *         <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     *         <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The
     *         model isn't usable.</li>
     *         <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * @see EntityStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the SizeInBytes property for this object.
     * 
     * @return The value of the SizeInBytes property for this object.
     */
    public Long sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The current endpoint of the <code>MLModel</code>.
     * </p>
     * 
     * @return The current endpoint of the <code>MLModel</code>.
     */
    public RealtimeEndpointInfo endpointInfo() {
        return endpointInfo;
    }

    /**
     * Returns true if the TrainingParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTrainingParameters() {
        return trainingParameters != null && !(trainingParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
     * pairs.
     * </p>
     * <p>
     * The following is the current set of training parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the
     * size of the model might affect its performance.
     * </p>
     * <p>
     * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
     * <code>33554432</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build
     * the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The
     * default value is <code>10</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
     * model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code>
     * and <code>none</code>. The default value is <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls overfitting the
     * data by penalizing large coefficients. This parameter tends to drive coefficients to zero, resulting in sparse
     * feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1
     * normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this
     * parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2
     * normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrainingParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
     *         key-value pairs.</p>
     *         <p>
     *         The following is the current set of training parameters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
     *         data, the size of the model might affect its performance.
     *         </p>
     *         <p>
     *         The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
     *         value is <code>33554432</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
     *         build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
     *         <code>10000</code>. The default value is <code>10</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves
     *         a model's ability to find the optimal solution for a variety of data types. The valid values are
     *         <code>auto</code> and <code>none</code>. The default value is <code>none</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls
     *         overfitting the data by penalizing large coefficients. This parameter tends to drive coefficients to
     *         zero, resulting in sparse feature set. If you use this parameter, start by specifying a small value, such
     *         as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls
     *         overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero
     *         values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     */
    public Map<String, String> trainingParameters() {
        return trainingParameters;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public String inputDataLocationS3() {
        return inputDataLocationS3;
    }

    /**
     * <p>
     * The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:
     * </p>
     * <ul>
     * <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient of
     * the loss function.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p>
     *         <ul>
     *         <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the
     *         gradient of the loss function.</li>
     * @see Algorithm
     */
    public Algorithm algorithm() {
        return Algorithm.fromValue(algorithm);
    }

    /**
     * <p>
     * The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:
     * </p>
     * <ul>
     * <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient of
     * the loss function.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p>
     *         <ul>
     *         <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the
     *         gradient of the loss function.</li>
     * @see Algorithm
     */
    public String algorithmAsString() {
        return algorithm;
    }

    /**
     * <p>
     * Identifies the <code>MLModel</code> category. The following are the available types:
     * </p>
     * <ul>
     * <li> <code>REGRESSION</code> - Produces a numeric result. For example, "What price should a house be listed at?"</li>
     * <li> <code>BINARY</code> - Produces one of two possible results. For example,
     * "Is this a child-friendly web site?".</li>
     * <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
     * "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
     * "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeAsString}.
     * </p>
     * 
     * @return Identifies the <code>MLModel</code> category. The following are the available types:</p>
     *         <ul>
     *         <li> <code>REGRESSION</code> - Produces a numeric result. For example,
     *         "What price should a house be listed at?"</li>
     *         <li> <code>BINARY</code> - Produces one of two possible results. For example,
     *         "Is this a child-friendly web site?".</li>
     *         <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
     *         "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
     *         "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
     * @see MLModelType
     */
    public MLModelType mlModelType() {
        return MLModelType.fromValue(mlModelType);
    }

    /**
     * <p>
     * Identifies the <code>MLModel</code> category. The following are the available types:
     * </p>
     * <ul>
     * <li> <code>REGRESSION</code> - Produces a numeric result. For example, "What price should a house be listed at?"</li>
     * <li> <code>BINARY</code> - Produces one of two possible results. For example,
     * "Is this a child-friendly web site?".</li>
     * <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
     * "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
     * "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mlModelType} will
     * return {@link MLModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mlModelTypeAsString}.
     * </p>
     * 
     * @return Identifies the <code>MLModel</code> category. The following are the available types:</p>
     *         <ul>
     *         <li> <code>REGRESSION</code> - Produces a numeric result. For example,
     *         "What price should a house be listed at?"</li>
     *         <li> <code>BINARY</code> - Produces one of two possible results. For example,
     *         "Is this a child-friendly web site?".</li>
     *         <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
     *         "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
     *         "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
     * @see MLModelType
     */
    public String mlModelTypeAsString() {
        return mlModelType;
    }

    /**
     * Returns the value of the ScoreThreshold property for this object.
     * 
     * @return The value of the ScoreThreshold property for this object.
     */
    public Float scoreThreshold() {
        return scoreThreshold;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     */
    public Instant scoreThresholdLastUpdatedAt() {
        return scoreThresholdLastUpdatedAt;
    }

    /**
     * <p>
     * A description of the most recent details about accessing the <code>MLModel</code>.
     * </p>
     * 
     * @return A description of the most recent details about accessing the <code>MLModel</code>.
     */
    public String message() {
        return message;
    }

    /**
     * Returns the value of the ComputeTime property for this object.
     * 
     * @return The value of the ComputeTime property for this object.
     */
    public Long computeTime() {
        return computeTime;
    }

    /**
     * Returns the value of the FinishedAt property for this object.
     * 
     * @return The value of the FinishedAt property for this object.
     */
    public Instant finishedAt() {
        return finishedAt;
    }

    /**
     * Returns the value of the StartedAt property for this object.
     * 
     * @return The value of the StartedAt property for this object.
     */
    public Instant startedAt() {
        return startedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(endpointInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingParameters() ? trainingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(scoreThresholdLastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLModel)) {
            return false;
        }
        MLModel other = (MLModel) obj;
        return Objects.equals(mlModelId(), other.mlModelId())
                && Objects.equals(trainingDataSourceId(), other.trainingDataSourceId())
                && Objects.equals(createdByIamUser(), other.createdByIamUser()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(sizeInBytes(), other.sizeInBytes())
                && Objects.equals(endpointInfo(), other.endpointInfo())
                && hasTrainingParameters() == other.hasTrainingParameters()
                && Objects.equals(trainingParameters(), other.trainingParameters())
                && Objects.equals(inputDataLocationS3(), other.inputDataLocationS3())
                && Objects.equals(algorithmAsString(), other.algorithmAsString())
                && Objects.equals(mlModelTypeAsString(), other.mlModelTypeAsString())
                && Objects.equals(scoreThreshold(), other.scoreThreshold())
                && Objects.equals(scoreThresholdLastUpdatedAt(), other.scoreThresholdLastUpdatedAt())
                && Objects.equals(message(), other.message()) && Objects.equals(computeTime(), other.computeTime())
                && Objects.equals(finishedAt(), other.finishedAt()) && Objects.equals(startedAt(), other.startedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MLModel").add("MLModelId", mlModelId()).add("TrainingDataSourceId", trainingDataSourceId())
                .add("CreatedByIamUser", createdByIamUser()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Name", name()).add("Status", statusAsString()).add("SizeInBytes", sizeInBytes())
                .add("EndpointInfo", endpointInfo())
                .add("TrainingParameters", hasTrainingParameters() ? trainingParameters() : null)
                .add("InputDataLocationS3", inputDataLocationS3()).add("Algorithm", algorithmAsString())
                .add("MLModelType", mlModelTypeAsString()).add("ScoreThreshold", scoreThreshold())
                .add("ScoreThresholdLastUpdatedAt", scoreThresholdLastUpdatedAt()).add("Message", message())
                .add("ComputeTime", computeTime()).add("FinishedAt", finishedAt()).add("StartedAt", startedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "TrainingDataSourceId":
            return Optional.ofNullable(clazz.cast(trainingDataSourceId()));
        case "CreatedByIamUser":
            return Optional.ofNullable(clazz.cast(createdByIamUser()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        case "EndpointInfo":
            return Optional.ofNullable(clazz.cast(endpointInfo()));
        case "TrainingParameters":
            return Optional.ofNullable(clazz.cast(trainingParameters()));
        case "InputDataLocationS3":
            return Optional.ofNullable(clazz.cast(inputDataLocationS3()));
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithmAsString()));
        case "MLModelType":
            return Optional.ofNullable(clazz.cast(mlModelTypeAsString()));
        case "ScoreThreshold":
            return Optional.ofNullable(clazz.cast(scoreThreshold()));
        case "ScoreThresholdLastUpdatedAt":
            return Optional.ofNullable(clazz.cast(scoreThresholdLastUpdatedAt()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ComputeTime":
            return Optional.ofNullable(clazz.cast(computeTime()));
        case "FinishedAt":
            return Optional.ofNullable(clazz.cast(finishedAt()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MLModel, T> g) {
        return obj -> g.apply((MLModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MLModel> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> at creation.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
         * <code>TrainingDataSourceId</code>.
         * </p>
         * 
         * @param trainingDataSourceId
         *        The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
         *        <code>TrainingDataSourceId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSourceId(String trainingDataSourceId);

        /**
         * <p>
         * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS
         * root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account from which the <code>MLModel</code> was created. The account type can be either
         *        an AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of an <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         * <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The model
         * isn't usable.</li>
         * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of an <code>MLModel</code>. This element can have one of the following values: </p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         *        <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The
         *        model isn't usable.</li>
         *        <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of an <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         * <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The model
         * isn't usable.</li>
         * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of an <code>MLModel</code>. This element can have one of the following values: </p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         *        <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The
         *        model isn't usable.</li>
         *        <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * Sets the value of the SizeInBytes property for this object.
         *
         * @param sizeInBytes
         *        The new value for the SizeInBytes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);

        /**
         * <p>
         * The current endpoint of the <code>MLModel</code>.
         * </p>
         * 
         * @param endpointInfo
         *        The current endpoint of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointInfo(RealtimeEndpointInfo endpointInfo);

        /**
         * <p>
         * The current endpoint of the <code>MLModel</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link RealtimeEndpointInfo.Builder} avoiding the need
         * to create one manually via {@link RealtimeEndpointInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link RealtimeEndpointInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointInfo(RealtimeEndpointInfo)}.
         * 
         * @param endpointInfo
         *        a consumer that will call methods on {@link RealtimeEndpointInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointInfo(RealtimeEndpointInfo)
         */
        default Builder endpointInfo(Consumer<RealtimeEndpointInfo.Builder> endpointInfo) {
            return endpointInfo(RealtimeEndpointInfo.builder().applyMutation(endpointInfo).build());
        }

        /**
         * <p>
         * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
         * pairs.
         * </p>
         * <p>
         * The following is the current set of training parameters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data,
         * the size of the model might affect its performance.
         * </p>
         * <p>
         * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
         * <code>33554432</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
         * build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>
         * . The default value is <code>10</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
         * model's ability to find the optimal solution for a variety of data types. The valid values are
         * <code>auto</code> and <code>none</code>. The default value is <code>none</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls overfitting
         * the data by penalizing large coefficients. This parameter tends to drive coefficients to zero, resulting in
         * sparse feature set. If you use this parameter, start by specifying a small value, such as
         * <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls overfitting
         * the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you
         * use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trainingParameters
         *        A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
         *        key-value pairs.</p>
         *        <p>
         *        The following is the current set of training parameters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
         *        data, the size of the model might affect its performance.
         *        </p>
         *        <p>
         *        The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
         *        value is <code>33554432</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations
         *        to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
         *        <code>10000</code>. The default value is <code>10</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data
         *        improves a model's ability to find the optimal solution for a variety of data types. The valid values
         *        are <code>auto</code> and <code>none</code>. The default value is <code>none</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls
         *        overfitting the data by penalizing large coefficients. This parameter tends to drive coefficients to
         *        zero, resulting in sparse feature set. If you use this parameter, start by specifying a small value,
         *        such as <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to small,
         *        nonzero values. If you use this parameter, start by specifying a small value, such as
         *        <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingParameters(Map<String, String> trainingParameters);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param inputDataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataLocationS3(String inputDataLocationS3);

        /**
         * <p>
         * The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:
         * </p>
         * <ul>
         * <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient
         * of the loss function.</li>
         * </ul>
         * 
         * @param algorithm
         *        The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p>
         *        <ul>
         *        <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the
         *        gradient of the loss function.</li>
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(String algorithm);

        /**
         * <p>
         * The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:
         * </p>
         * <ul>
         * <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient
         * of the loss function.</li>
         * </ul>
         * 
         * @param algorithm
         *        The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p>
         *        <ul>
         *        <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the
         *        gradient of the loss function.</li>
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(Algorithm algorithm);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         * "What price should a house be listed at?"</li>
         * <li> <code>BINARY</code> - Produces one of two possible results. For example,
         * "Is this a child-friendly web site?".</li>
         * <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         * "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
         * "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types:</p>
         *        <ul>
         *        <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         *        "What price should a house be listed at?"</li>
         *        <li> <code>BINARY</code> - Produces one of two possible results. For example,
         *        "Is this a child-friendly web site?".</li>
         *        <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         *        "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="
         *        annbech" timestamp="20160328T175050-0700" content="
         *        "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".
         *        </li>
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(String mlModelType);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         * "What price should a house be listed at?"</li>
         * <li> <code>BINARY</code> - Produces one of two possible results. For example,
         * "Is this a child-friendly web site?".</li>
         * <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         * "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
         * "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types:</p>
         *        <ul>
         *        <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         *        "What price should a house be listed at?"</li>
         *        <li> <code>BINARY</code> - Produces one of two possible results. For example,
         *        "Is this a child-friendly web site?".</li>
         *        <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         *        "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="
         *        annbech" timestamp="20160328T175050-0700" content="
         *        "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".
         *        </li>
         * @see MLModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(MLModelType mlModelType);

        /**
         * Sets the value of the ScoreThreshold property for this object.
         *
         * @param scoreThreshold
         *        The new value for the ScoreThreshold property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThreshold(Float scoreThreshold);

        /**
         * <p>
         * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param scoreThresholdLastUpdatedAt
         *        The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt);

        /**
         * <p>
         * A description of the most recent details about accessing the <code>MLModel</code>.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about accessing the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * Sets the value of the ComputeTime property for this object.
         *
         * @param computeTime
         *        The new value for the ComputeTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * Sets the value of the FinishedAt property for this object.
         *
         * @param finishedAt
         *        The new value for the FinishedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * Sets the value of the StartedAt property for this object.
         *
         * @param startedAt
         *        The new value for the StartedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);
    }

    static final class BuilderImpl implements Builder {
        private String mlModelId;

        private String trainingDataSourceId;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String name;

        private String status;

        private Long sizeInBytes;

        private RealtimeEndpointInfo endpointInfo;

        private Map<String, String> trainingParameters = DefaultSdkAutoConstructMap.getInstance();

        private String inputDataLocationS3;

        private String algorithm;

        private String mlModelType;

        private Float scoreThreshold;

        private Instant scoreThresholdLastUpdatedAt;

        private String message;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MLModel model) {
            mlModelId(model.mlModelId);
            trainingDataSourceId(model.trainingDataSourceId);
            createdByIamUser(model.createdByIamUser);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            status(model.status);
            sizeInBytes(model.sizeInBytes);
            endpointInfo(model.endpointInfo);
            trainingParameters(model.trainingParameters);
            inputDataLocationS3(model.inputDataLocationS3);
            algorithm(model.algorithm);
            mlModelType(model.mlModelType);
            scoreThreshold(model.scoreThreshold);
            scoreThresholdLastUpdatedAt(model.scoreThresholdLastUpdatedAt);
            message(model.message);
            computeTime(model.computeTime);
            finishedAt(model.finishedAt);
            startedAt(model.startedAt);
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getTrainingDataSourceId() {
            return trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final RealtimeEndpointInfo.Builder getEndpointInfo() {
            return endpointInfo != null ? endpointInfo.toBuilder() : null;
        }

        @Override
        public final Builder endpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final void setEndpointInfo(RealtimeEndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        public final Map<String, String> getTrainingParameters() {
            if (trainingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return trainingParameters;
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        public final String getInputDataLocationS3() {
            return inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getAlgorithm() {
            return algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getMlModelType() {
            return mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType == null ? null : mlModelType.toString());
            return this;
        }

        public final void setMlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final Float getScoreThreshold() {
            return scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public final Instant getScoreThresholdLastUpdatedAt() {
            return scoreThresholdLastUpdatedAt;
        }

        @Override
        public final Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
            return this;
        }

        public final void setScoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public MLModel build() {
            return new MLModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
