/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateDataSourceFromRedshift</code> operation, and is an acknowledgement that Amazon
 * ML received the request.
 * </p>
 * <p>
 * The <code>CreateDataSourceFromRedshift</code> operation is asynchronous. You can poll for updates by using the
 * <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceFromRedshiftResponse extends MachineLearningResponse implements
        ToCopyableBuilder<CreateDataSourceFromRedshiftResponse.Builder, CreateDataSourceFromRedshiftResponse> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(CreateDataSourceFromRedshiftResponse::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD));

    private final String dataSourceId;

    private CreateDataSourceFromRedshiftResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
     * <code>DataSourceID</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value
     *         of the <code>DataSourceID</code> in the request.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRedshiftResponse)) {
            return false;
        }
        CreateDataSourceFromRedshiftResponse other = (CreateDataSourceFromRedshiftResponse) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDataSourceFromRedshiftResponse").add("DataSourceId", dataSourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromRedshiftResponse, T> g) {
        return obj -> g.apply((CreateDataSourceFromRedshiftResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataSourceFromRedshiftResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of
         * the <code>DataSourceID</code> in the request.
         * </p>
         * 
         * @param dataSourceId
         *        A user-supplied ID that uniquely identifies the datasource. This value should be identical to the
         *        value of the <code>DataSourceID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRedshiftResponse model) {
            super(model);
            dataSourceId(model.dataSourceId);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public CreateDataSourceFromRedshiftResponse build() {
            return new CreateDataSourceFromRedshiftResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
