/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSourcesRequest extends MachineLearningRequest implements
        ToCopyableBuilder<DescribeDataSourcesRequest.Builder, DescribeDataSourcesRequest> {
    private static final SdkField<String> FILTER_VARIABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterVariable").getter(getter(DescribeDataSourcesRequest::filterVariableAsString))
            .setter(setter(Builder::filterVariable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterVariable").build()).build();

    private static final SdkField<String> EQ_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EQ")
            .getter(getter(DescribeDataSourcesRequest::eq)).setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EQ").build()).build();

    private static final SdkField<String> GT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("GT")
            .getter(getter(DescribeDataSourcesRequest::gt)).setter(setter(Builder::gt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GT").build()).build();

    private static final SdkField<String> LT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LT")
            .getter(getter(DescribeDataSourcesRequest::lt)).setter(setter(Builder::lt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LT").build()).build();

    private static final SdkField<String> GE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("GE")
            .getter(getter(DescribeDataSourcesRequest::ge)).setter(setter(Builder::ge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GE").build()).build();

    private static final SdkField<String> LE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LE")
            .getter(getter(DescribeDataSourcesRequest::le)).setter(setter(Builder::le))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LE").build()).build();

    private static final SdkField<String> NE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NE")
            .getter(getter(DescribeDataSourcesRequest::ne)).setter(setter(Builder::ne))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NE").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(DescribeDataSourcesRequest::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(DescribeDataSourcesRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDataSourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeDataSourcesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_VARIABLE_FIELD,
            EQ_FIELD, GT_FIELD, LT_FIELD, GE_FIELD, LE_FIELD, NE_FIELD, PREFIX_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD,
            LIMIT_FIELD));

    private final String filterVariable;

    private final String eq;

    private final String gt;

    private final String lt;

    private final String ge;

    private final String le;

    private final String ne;

    private final String prefix;

    private final String sortOrder;

    private final String nextToken;

    private final Integer limit;

    private DescribeDataSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.filterVariable = builder.filterVariable;
        this.eq = builder.eq;
        this.gt = builder.gt;
        this.lt = builder.lt;
        this.ge = builder.ge;
        this.le = builder.le;
        this.ne = builder.ne;
        this.prefix = builder.prefix;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * Use one of the following variables to filter a list of <code>DataSource</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
     * <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3)
     * bucket or directory.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code>
     * creation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterVariable}
     * will return {@link DataSourceFilterVariable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterVariableAsString}.
     * </p>
     * 
     * @return Use one of the following variables to filter a list of <code>DataSource</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
     *         <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon
     *         S3) bucket or directory.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IAMUser</code> - Sets the search criteria to the user account that invoked the
     *         <code>DataSource</code> creation.
     *         </p>
     *         </li>
     * @see DataSourceFilterVariable
     */
    public final DataSourceFilterVariable filterVariable() {
        return DataSourceFilterVariable.fromValue(filterVariable);
    }

    /**
     * <p>
     * Use one of the following variables to filter a list of <code>DataSource</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
     * <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3)
     * bucket or directory.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code>
     * creation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterVariable}
     * will return {@link DataSourceFilterVariable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterVariableAsString}.
     * </p>
     * 
     * @return Use one of the following variables to filter a list of <code>DataSource</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
     *         <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon
     *         S3) bucket or directory.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IAMUser</code> - Sets the search criteria to the user account that invoked the
     *         <code>DataSource</code> creation.
     *         </p>
     *         </li>
     * @see DataSourceFilterVariable
     */
    public final String filterVariableAsString() {
        return filterVariable;
    }

    /**
     * <p>
     * The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that
     * exactly match the value specified with <code>EQ</code>.
     * </p>
     * 
     * @return The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values
     *         that exactly match the value specified with <code>EQ</code>.
     */
    public final String eq() {
        return eq;
    }

    /**
     * <p>
     * The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that
     * are greater than the value specified with <code>GT</code>.
     * </p>
     * 
     * @return The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
     *         values that are greater than the value specified with <code>GT</code>.
     */
    public final String gt() {
        return gt;
    }

    /**
     * <p>
     * The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are
     * less than the value specified with <code>LT</code>.
     * </p>
     * 
     * @return The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values
     *         that are less than the value specified with <code>LT</code>.
     */
    public final String lt() {
        return lt;
    }

    /**
     * <p>
     * The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
     * values that are greater than or equal to the value specified with <code>GE</code>.
     * </p>
     * 
     * @return The greater than or equal to operator. The <code>DataSource</code> results will have
     *         <code>FilterVariable</code> values that are greater than or equal to the value specified with
     *         <code>GE</code>.
     */
    public final String ge() {
        return ge;
    }

    /**
     * <p>
     * The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
     * values that are less than or equal to the value specified with <code>LE</code>.
     * </p>
     * 
     * @return The less than or equal to operator. The <code>DataSource</code> results will have
     *         <code>FilterVariable</code> values that are less than or equal to the value specified with
     *         <code>LE</code>.
     */
    public final String le() {
        return le;
    }

    /**
     * <p>
     * The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not
     * equal to the value specified with <code>NE</code>.
     * </p>
     * 
     * @return The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
     *         values not equal to the value specified with <code>NE</code>.
     */
    public final String ne() {
        return ne;
    }

    /**
     * <p>
     * A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.
     * </p>
     * <p>
     * For example, a <code>DataSource</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>
     * . To search for this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and
     * any of the following strings for the <code>Prefix</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 2014-09
     * </p>
     * </li>
     * <li>
     * <p>
     * 2014-09-09
     * </p>
     * </li>
     * <li>
     * <p>
     * 2014-09-09-Holiday
     * </p>
     * </li>
     * </ul>
     * 
     * @return A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
     *         <p>
     *         For example, a <code>DataSource</code> could have the <code>Name</code>
     *         <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>DataSource</code>, select
     *         <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
     *         <code>Prefix</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         2014-09
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2014-09-09
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2014-09-09-Holiday
     *         </p>
     *         </li>
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Results are sorted by <code>FilterVariable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Results are sorted by <code>FilterVariable</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Results are sorted by <code>FilterVariable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Results are sorted by <code>FilterVariable</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The ID of the page in the paginated results.
     * </p>
     * 
     * @return The ID of the page in the paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of <code>DataSource</code> to include in the result.
     * </p>
     * 
     * @return The maximum number of <code>DataSource</code> to include in the result.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterVariableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eq());
        hashCode = 31 * hashCode + Objects.hashCode(gt());
        hashCode = 31 * hashCode + Objects.hashCode(lt());
        hashCode = 31 * hashCode + Objects.hashCode(ge());
        hashCode = 31 * hashCode + Objects.hashCode(le());
        hashCode = 31 * hashCode + Objects.hashCode(ne());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSourcesRequest)) {
            return false;
        }
        DescribeDataSourcesRequest other = (DescribeDataSourcesRequest) obj;
        return Objects.equals(filterVariableAsString(), other.filterVariableAsString()) && Objects.equals(eq(), other.eq())
                && Objects.equals(gt(), other.gt()) && Objects.equals(lt(), other.lt()) && Objects.equals(ge(), other.ge())
                && Objects.equals(le(), other.le()) && Objects.equals(ne(), other.ne())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataSourcesRequest").add("FilterVariable", filterVariableAsString()).add("EQ", eq())
                .add("GT", gt()).add("LT", lt()).add("GE", ge()).add("LE", le()).add("NE", ne()).add("Prefix", prefix())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterVariable":
            return Optional.ofNullable(clazz.cast(filterVariableAsString()));
        case "EQ":
            return Optional.ofNullable(clazz.cast(eq()));
        case "GT":
            return Optional.ofNullable(clazz.cast(gt()));
        case "LT":
            return Optional.ofNullable(clazz.cast(lt()));
        case "GE":
            return Optional.ofNullable(clazz.cast(ge()));
        case "LE":
            return Optional.ofNullable(clazz.cast(le()));
        case "NE":
            return Optional.ofNullable(clazz.cast(ne()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSourcesRequest, T> g) {
        return obj -> g.apply((DescribeDataSourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataSourcesRequest> {
        /**
         * <p>
         * Use one of the following variables to filter a list of <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
         * <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3)
         * bucket or directory.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code>
         * creation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filterVariable
         *        Use one of the following variables to filter a list of <code>DataSource</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
         *        <code>Name</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
         *        <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service
         *        (Amazon S3) bucket or directory.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IAMUser</code> - Sets the search criteria to the user account that invoked the
         *        <code>DataSource</code> creation.
         *        </p>
         *        </li>
         * @see DataSourceFilterVariable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceFilterVariable
         */
        Builder filterVariable(String filterVariable);

        /**
         * <p>
         * Use one of the following variables to filter a list of <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
         * <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3)
         * bucket or directory.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code>
         * creation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filterVariable
         *        Use one of the following variables to filter a list of <code>DataSource</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
         *        <code>Name</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the
         *        <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service
         *        (Amazon S3) bucket or directory.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IAMUser</code> - Sets the search criteria to the user account that invoked the
         *        <code>DataSource</code> creation.
         *        </p>
         *        </li>
         * @see DataSourceFilterVariable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceFilterVariable
         */
        Builder filterVariable(DataSourceFilterVariable filterVariable);

        /**
         * <p>
         * The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that
         * exactly match the value specified with <code>EQ</code>.
         * </p>
         * 
         * @param eq
         *        The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
         *        values that exactly match the value specified with <code>EQ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String eq);

        /**
         * <p>
         * The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values
         * that are greater than the value specified with <code>GT</code>.
         * </p>
         * 
         * @param gt
         *        The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
         *        values that are greater than the value specified with <code>GT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gt(String gt);

        /**
         * <p>
         * The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that
         * are less than the value specified with <code>LT</code>.
         * </p>
         * 
         * @param lt
         *        The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
         *        values that are less than the value specified with <code>LT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lt(String lt);

        /**
         * <p>
         * The greater than or equal to operator. The <code>DataSource</code> results will have
         * <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>
         * .
         * </p>
         * 
         * @param ge
         *        The greater than or equal to operator. The <code>DataSource</code> results will have
         *        <code>FilterVariable</code> values that are greater than or equal to the value specified with
         *        <code>GE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ge(String ge);

        /**
         * <p>
         * The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
         * values that are less than or equal to the value specified with <code>LE</code>.
         * </p>
         * 
         * @param le
         *        The less than or equal to operator. The <code>DataSource</code> results will have
         *        <code>FilterVariable</code> values that are less than or equal to the value specified with
         *        <code>LE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder le(String le);

        /**
         * <p>
         * The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values
         * not equal to the value specified with <code>NE</code>.
         * </p>
         * 
         * @param ne
         *        The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code>
         *        values not equal to the value specified with <code>NE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ne(String ne);

        /**
         * <p>
         * A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.
         * </p>
         * <p>
         * For example, a <code>DataSource</code> could have the <code>Name</code>
         * <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>DataSource</code>, select
         * <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
         * <code>Prefix</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 2014-09
         * </p>
         * </li>
         * <li>
         * <p>
         * 2014-09-09
         * </p>
         * </li>
         * <li>
         * <p>
         * 2014-09-09-Holiday
         * </p>
         * </li>
         * </ul>
         * 
         * @param prefix
         *        A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>
         *        .</p>
         *        <p>
         *        For example, a <code>DataSource</code> could have the <code>Name</code>
         *        <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>DataSource</code>, select
         *        <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
         *        <code>Prefix</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        2014-09
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2014-09-09
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2014-09-09-Holiday
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
         * </p>
         * </li>
         * </ul>
         * <p>
         * Results are sorted by <code>FilterVariable</code>.
         * </p>
         * 
         * @param sortOrder
         *        A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>
         *        .</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Results are sorted by <code>FilterVariable</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
         * </p>
         * </li>
         * </ul>
         * <p>
         * Results are sorted by <code>FilterVariable</code>.
         * </p>
         * 
         * @param sortOrder
         *        A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>
         *        .</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Results are sorted by <code>FilterVariable</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The ID of the page in the paginated results.
         * </p>
         * 
         * @param nextToken
         *        The ID of the page in the paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of <code>DataSource</code> to include in the result.
         * </p>
         * 
         * @param limit
         *        The maximum number of <code>DataSource</code> to include in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String filterVariable;

        private String eq;

        private String gt;

        private String lt;

        private String ge;

        private String le;

        private String ne;

        private String prefix;

        private String sortOrder;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSourcesRequest model) {
            super(model);
            filterVariable(model.filterVariable);
            eq(model.eq);
            gt(model.gt);
            lt(model.lt);
            ge(model.ge);
            le(model.le);
            ne(model.ne);
            prefix(model.prefix);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getFilterVariable() {
            return filterVariable;
        }

        public final void setFilterVariable(String filterVariable) {
            this.filterVariable = filterVariable;
        }

        @Override
        @Transient
        public final Builder filterVariable(String filterVariable) {
            this.filterVariable = filterVariable;
            return this;
        }

        @Override
        @Transient
        public final Builder filterVariable(DataSourceFilterVariable filterVariable) {
            this.filterVariable(filterVariable == null ? null : filterVariable.toString());
            return this;
        }

        public final String getEq() {
            return eq;
        }

        public final void setEq(String eq) {
            this.eq = eq;
        }

        @Override
        @Transient
        public final Builder eq(String eq) {
            this.eq = eq;
            return this;
        }

        public final String getGt() {
            return gt;
        }

        public final void setGt(String gt) {
            this.gt = gt;
        }

        @Override
        @Transient
        public final Builder gt(String gt) {
            this.gt = gt;
            return this;
        }

        public final String getLt() {
            return lt;
        }

        public final void setLt(String lt) {
            this.lt = lt;
        }

        @Override
        @Transient
        public final Builder lt(String lt) {
            this.lt = lt;
            return this;
        }

        public final String getGe() {
            return ge;
        }

        public final void setGe(String ge) {
            this.ge = ge;
        }

        @Override
        @Transient
        public final Builder ge(String ge) {
            this.ge = ge;
            return this;
        }

        public final String getLe() {
            return le;
        }

        public final void setLe(String le) {
            this.le = le;
        }

        @Override
        @Transient
        public final Builder le(String le) {
            this.le = le;
            return this;
        }

        public final String getNe() {
            return ne;
        }

        public final void setNe(String ne) {
            this.ne = ne;
        }

        @Override
        @Transient
        public final Builder ne(String ne) {
            this.ne = ne;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        @Transient
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDataSourcesRequest build() {
            return new DescribeDataSourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
