/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>DeleteRealtimeEndpoint</code> operation.
 * </p>
 * <p>
 * The result contains the <code>MLModelId</code> and the endpoint information for the <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRealtimeEndpointResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DeleteRealtimeEndpointResponse.Builder, DeleteRealtimeEndpointResponse> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelId").getter(getter(DeleteRealtimeEndpointResponse::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final SdkField<RealtimeEndpointInfo> REALTIME_ENDPOINT_INFO_FIELD = SdkField
            .<RealtimeEndpointInfo> builder(MarshallingType.SDK_POJO).memberName("RealtimeEndpointInfo")
            .getter(getter(DeleteRealtimeEndpointResponse::realtimeEndpointInfo)).setter(setter(Builder::realtimeEndpointInfo))
            .constructor(RealtimeEndpointInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeEndpointInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD,
            REALTIME_ENDPOINT_INFO_FIELD));

    private final String mlModelId;

    private final RealtimeEndpointInfo realtimeEndpointInfo;

    private DeleteRealtimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.realtimeEndpointInfo = builder.realtimeEndpointInfo;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value
     * of the <code>MLModelId</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to
     *         the value of the <code>MLModelId</code> in the request.
     */
    public final String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The endpoint information of the <code>MLModel</code>
     * </p>
     * 
     * @return The endpoint information of the <code>MLModel</code>
     */
    public final RealtimeEndpointInfo realtimeEndpointInfo() {
        return realtimeEndpointInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(realtimeEndpointInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRealtimeEndpointResponse)) {
            return false;
        }
        DeleteRealtimeEndpointResponse other = (DeleteRealtimeEndpointResponse) obj;
        return Objects.equals(mlModelId(), other.mlModelId())
                && Objects.equals(realtimeEndpointInfo(), other.realtimeEndpointInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRealtimeEndpointResponse").add("MLModelId", mlModelId())
                .add("RealtimeEndpointInfo", realtimeEndpointInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "RealtimeEndpointInfo":
            return Optional.ofNullable(clazz.cast(realtimeEndpointInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRealtimeEndpointResponse, T> g) {
        return obj -> g.apply((DeleteRealtimeEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRealtimeEndpointResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the
         * value of the <code>MLModelId</code> in the request.
         * </p>
         * 
         * @param mlModelId
         *        A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical
         *        to the value of the <code>MLModelId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The endpoint information of the <code>MLModel</code>
         * </p>
         * 
         * @param realtimeEndpointInfo
         *        The endpoint information of the <code>MLModel</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeEndpointInfo(RealtimeEndpointInfo realtimeEndpointInfo);

        /**
         * <p>
         * The endpoint information of the <code>MLModel</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link RealtimeEndpointInfo.Builder} avoiding
         * the need to create one manually via {@link RealtimeEndpointInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link RealtimeEndpointInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #realtimeEndpointInfo(RealtimeEndpointInfo)}.
         * 
         * @param realtimeEndpointInfo
         *        a consumer that will call methods on {@link RealtimeEndpointInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realtimeEndpointInfo(RealtimeEndpointInfo)
         */
        default Builder realtimeEndpointInfo(Consumer<RealtimeEndpointInfo.Builder> realtimeEndpointInfo) {
            return realtimeEndpointInfo(RealtimeEndpointInfo.builder().applyMutation(realtimeEndpointInfo).build());
        }
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String mlModelId;

        private RealtimeEndpointInfo realtimeEndpointInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRealtimeEndpointResponse model) {
            super(model);
            mlModelId(model.mlModelId);
            realtimeEndpointInfo(model.realtimeEndpointInfo);
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        @Transient
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final RealtimeEndpointInfo.Builder getRealtimeEndpointInfo() {
            return realtimeEndpointInfo != null ? realtimeEndpointInfo.toBuilder() : null;
        }

        public final void setRealtimeEndpointInfo(RealtimeEndpointInfo.BuilderImpl realtimeEndpointInfo) {
            this.realtimeEndpointInfo = realtimeEndpointInfo != null ? realtimeEndpointInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder realtimeEndpointInfo(RealtimeEndpointInfo realtimeEndpointInfo) {
            this.realtimeEndpointInfo = realtimeEndpointInfo;
            return this;
        }

        @Override
        public DeleteRealtimeEndpointResponse build() {
            return new DeleteRealtimeEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
