/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the query results from a <code>DescribeEvaluations</code> operation. The content is essentially a list of
 * <code>Evaluation</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEvaluationsResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DescribeEvaluationsResponse.Builder, DescribeEvaluationsResponse> {
    private static final SdkField<List<Evaluation>> RESULTS_FIELD = SdkField
            .<List<Evaluation>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(DescribeEvaluationsResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Evaluation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Evaluation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEvaluationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Evaluation> results;

    private final String nextToken;

    private DescribeEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Evaluation</code> that meet the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return A list of <code>Evaluation</code> that meet the search criteria.
     */
    public final List<Evaluation> results() {
        return results;
    }

    /**
     * <p>
     * The ID of the next page in the paginated results that indicates at least one more page follows.
     * </p>
     * 
     * @return The ID of the next page in the paginated results that indicates at least one more page follows.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEvaluationsResponse)) {
            return false;
        }
        DescribeEvaluationsResponse other = (DescribeEvaluationsResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEvaluationsResponse").add("Results", hasResults() ? results() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEvaluationsResponse, T> g) {
        return obj -> g.apply((DescribeEvaluationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEvaluationsResponse> {
        /**
         * <p>
         * A list of <code>Evaluation</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>Evaluation</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<Evaluation> results);

        /**
         * <p>
         * A list of <code>Evaluation</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>Evaluation</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Evaluation... results);

        /**
         * <p>
         * A list of <code>Evaluation</code> that meet the search criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Evaluation>.Builder} avoiding the
         * need to create one manually via {@link List<Evaluation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Evaluation>.Builder#build()} is called immediately and its
         * result is passed to {@link #results(List<Evaluation>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<Evaluation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<Evaluation>)
         */
        Builder results(Consumer<Evaluation.Builder>... results);

        /**
         * <p>
         * The ID of the next page in the paginated results that indicates at least one more page follows.
         * </p>
         * 
         * @param nextToken
         *        The ID of the next page in the paginated results that indicates at least one more page follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private List<Evaluation> results = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEvaluationsResponse model) {
            super(model);
            results(model.results);
            nextToken(model.nextToken);
        }

        public final List<Evaluation.Builder> getResults() {
            List<Evaluation.Builder> result = EvaluationsCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<Evaluation.BuilderImpl> results) {
            this.results = EvaluationsCopier.copyFromBuilder(results);
        }

        @Override
        @Transient
        public final Builder results(Collection<Evaluation> results) {
            this.results = EvaluationsCopier.copy(results);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(Evaluation... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(Consumer<Evaluation.Builder>... results) {
            results(Stream.of(results).map(c -> Evaluation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEvaluationsResponse build() {
            return new DescribeEvaluationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
