/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdateBatchPrediction</code> operation.
 * </p>
 * <p>
 * You can see the updated content by using the <code>GetBatchPrediction</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBatchPredictionResponse extends MachineLearningResponse implements
        ToCopyableBuilder<UpdateBatchPredictionResponse.Builder, UpdateBatchPredictionResponse> {
    private static final SdkField<String> BATCH_PREDICTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchPredictionId").getter(getter(UpdateBatchPredictionResponse::batchPredictionId))
            .setter(setter(Builder::batchPredictionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTION_ID_FIELD));

    private final String batchPredictionId;

    private UpdateBatchPredictionResponse(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
    }

    /**
     * <p>
     * The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to the value
     * of the <code>BatchPredictionId</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to
     *         the value of the <code>BatchPredictionId</code> in the request.
     */
    public final String batchPredictionId() {
        return batchPredictionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBatchPredictionResponse)) {
            return false;
        }
        UpdateBatchPredictionResponse other = (UpdateBatchPredictionResponse) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBatchPredictionResponse").add("BatchPredictionId", batchPredictionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.ofNullable(clazz.cast(batchPredictionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBatchPredictionResponse, T> g) {
        return obj -> g.apply((UpdateBatchPredictionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBatchPredictionResponse> {
        /**
         * <p>
         * The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to the
         * value of the <code>BatchPredictionId</code> in the request.
         * </p>
         * 
         * @param batchPredictionId
         *        The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to
         *        the value of the <code>BatchPredictionId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String batchPredictionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBatchPredictionResponse model) {
            super(model);
            batchPredictionId(model.batchPredictionId);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        @Transient
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        @Override
        public UpdateBatchPredictionResponse build() {
            return new UpdateBatchPredictionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
