/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.machinelearning.model.MLModel;
import software.amazon.awssdk.services.machinelearning.model.MLModelsCopier;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMlModelsResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, DescribeMlModelsResponse> {
    private static final SdkField<List<MLModel>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(DescribeMlModelsResponse.getter(DescribeMlModelsResponse::results)).setter(DescribeMlModelsResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MLModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMlModelsResponse.getter(DescribeMlModelsResponse::nextToken)).setter(DescribeMlModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MLModel> results;
    private final String nextToken;

    private DescribeMlModelsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<MLModel> results() {
        return this.results;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMlModelsResponse)) {
            return false;
        }
        DescribeMlModelsResponse other = (DescribeMlModelsResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMlModelsResponse").add("Results", this.hasResults() ? this.results() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMlModelsResponse, T> g) {
        return obj -> g.apply((DescribeMlModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private List<MLModel> results = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMlModelsResponse model) {
            super(model);
            this.results(model.results);
            this.nextToken(model.nextToken);
        }

        public final List<MLModel.Builder> getResults() {
            List<MLModel.Builder> result = MLModelsCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<MLModel.BuilderImpl> results) {
            this.results = MLModelsCopier.copyFromBuilder(results);
        }

        @Override
        @Transient
        public final Builder results(Collection<MLModel> results) {
            this.results = MLModelsCopier.copy(results);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(MLModel ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(Consumer<MLModel.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (MLModel)((MLModel.Builder)MLModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMlModelsResponse build() {
            return new DescribeMlModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMlModelsResponse> {
        public Builder results(Collection<MLModel> var1);

        public Builder results(MLModel ... var1);

        public Builder results(Consumer<MLModel.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

