/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBatchPredictionRequest extends MachineLearningRequest implements
        ToCopyableBuilder<UpdateBatchPredictionRequest.Builder, UpdateBatchPredictionRequest> {
    private static final SdkField<String> BATCH_PREDICTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchPredictionId").getter(getter(UpdateBatchPredictionRequest::batchPredictionId))
            .setter(setter(Builder::batchPredictionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionId").build()).build();

    private static final SdkField<String> BATCH_PREDICTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BatchPredictionName").getter(getter(UpdateBatchPredictionRequest::batchPredictionName))
            .setter(setter(Builder::batchPredictionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTION_ID_FIELD,
            BATCH_PREDICTION_NAME_FIELD));

    private final String batchPredictionId;

    private final String batchPredictionName;

    private UpdateBatchPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
        this.batchPredictionName = builder.batchPredictionName;
    }

    /**
     * <p>
     * The ID assigned to the <code>BatchPrediction</code> during creation.
     * </p>
     * 
     * @return The ID assigned to the <code>BatchPrediction</code> during creation.
     */
    public final String batchPredictionId() {
        return batchPredictionId;
    }

    /**
     * <p>
     * A new user-supplied name or description of the <code>BatchPrediction</code>.
     * </p>
     * 
     * @return A new user-supplied name or description of the <code>BatchPrediction</code>.
     */
    public final String batchPredictionName() {
        return batchPredictionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBatchPredictionRequest)) {
            return false;
        }
        UpdateBatchPredictionRequest other = (UpdateBatchPredictionRequest) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId())
                && Objects.equals(batchPredictionName(), other.batchPredictionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBatchPredictionRequest").add("BatchPredictionId", batchPredictionId())
                .add("BatchPredictionName", batchPredictionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.ofNullable(clazz.cast(batchPredictionId()));
        case "BatchPredictionName":
            return Optional.ofNullable(clazz.cast(batchPredictionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBatchPredictionRequest, T> g) {
        return obj -> g.apply((UpdateBatchPredictionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBatchPredictionRequest> {
        /**
         * <p>
         * The ID assigned to the <code>BatchPrediction</code> during creation.
         * </p>
         * 
         * @param batchPredictionId
         *        The ID assigned to the <code>BatchPrediction</code> during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);

        /**
         * <p>
         * A new user-supplied name or description of the <code>BatchPrediction</code>.
         * </p>
         * 
         * @param batchPredictionName
         *        A new user-supplied name or description of the <code>BatchPrediction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionName(String batchPredictionName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String batchPredictionId;

        private String batchPredictionName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBatchPredictionRequest model) {
            super(model);
            batchPredictionId(model.batchPredictionId);
            batchPredictionName(model.batchPredictionName);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        @Transient
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final String getBatchPredictionName() {
            return batchPredictionName;
        }

        public final void setBatchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
        }

        @Override
        @Transient
        public final Builder batchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBatchPredictionRequest build() {
            return new UpdateBatchPredictionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
