/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The datasource details that are specific to Amazon RDS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSMetadata implements SdkPojo, Serializable, ToCopyableBuilder<RDSMetadata.Builder, RDSMetadata> {
    private static final SdkField<RDSDatabase> DATABASE_FIELD = SdkField.<RDSDatabase> builder(MarshallingType.SDK_POJO)
            .getter(getter(RDSMetadata::database)).setter(setter(Builder::database)).constructor(RDSDatabase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DATABASE_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RDSMetadata::databaseUserName)).setter(setter(Builder::databaseUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseUserName").build()).build();

    private static final SdkField<String> SELECT_SQL_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RDSMetadata::selectSqlQuery)).setter(setter(Builder::selectSqlQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectSqlQuery").build()).build();

    private static final SdkField<String> RESOURCE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RDSMetadata::resourceRole)).setter(setter(Builder::resourceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRole").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RDSMetadata::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<String> DATA_PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RDSMetadata::dataPipelineId)).setter(setter(Builder::dataPipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPipelineId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD,
            DATABASE_USER_NAME_FIELD, SELECT_SQL_QUERY_FIELD, RESOURCE_ROLE_FIELD, SERVICE_ROLE_FIELD, DATA_PIPELINE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final RDSDatabase database;

    private final String databaseUserName;

    private final String selectSqlQuery;

    private final String resourceRole;

    private final String serviceRole;

    private final String dataPipelineId;

    private RDSMetadata(BuilderImpl builder) {
        this.database = builder.database;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.dataPipelineId = builder.dataPipelineId;
    }

    /**
     * <p>
     * The database details required to connect to an Amazon RDS.
     * </p>
     * 
     * @return The database details required to connect to an Amazon RDS.
     */
    public RDSDatabase database() {
        return database;
    }

    /**
     * Returns the value of the DatabaseUserName property for this object.
     * 
     * @return The value of the DatabaseUserName property for this object.
     */
    public String databaseUserName() {
        return databaseUserName;
    }

    /**
     * <p>
     * The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if <code>Verbose</code> is
     * true in <code>GetDataSourceInput</code>.
     * </p>
     * 
     * @return The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if
     *         <code>Verbose</code> is true in <code>GetDataSourceInput</code>.
     */
    public String selectSqlQuery() {
        return selectSqlQuery;
    }

    /**
     * <p>
     * The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task from
     * Amazon RDS to Amazon S3. For more information, see <a
     * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
     * data pipelines.
     * </p>
     * 
     * @return The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task
     *         from Amazon RDS to Amazon S3. For more information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a>
     *         for data pipelines.
     */
    public String resourceRole() {
        return resourceRole;
    }

    /**
     * <p>
     * The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the copy task
     * from Amazon RDS to Amazon S3. For more information, see <a
     * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
     * data pipelines.
     * </p>
     * 
     * @return The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the
     *         copy task from Amazon RDS to Amazon S3. For more information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a>
     *         for data pipelines.
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You can use
     * the ID to find details about the instance in the Data Pipeline console.
     * </p>
     * 
     * @return The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You
     *         can use the ID to find details about the instance in the Data Pipeline console.
     */
    public String dataPipelineId() {
        return dataPipelineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(databaseUserName());
        hashCode = 31 * hashCode + Objects.hashCode(selectSqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(dataPipelineId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSMetadata)) {
            return false;
        }
        RDSMetadata other = (RDSMetadata) obj;
        return Objects.equals(database(), other.database()) && Objects.equals(databaseUserName(), other.databaseUserName())
                && Objects.equals(selectSqlQuery(), other.selectSqlQuery())
                && Objects.equals(resourceRole(), other.resourceRole()) && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(dataPipelineId(), other.dataPipelineId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RDSMetadata").add("Database", database()).add("DatabaseUserName", databaseUserName())
                .add("SelectSqlQuery", selectSqlQuery()).add("ResourceRole", resourceRole()).add("ServiceRole", serviceRole())
                .add("DataPipelineId", dataPipelineId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DatabaseUserName":
            return Optional.ofNullable(clazz.cast(databaseUserName()));
        case "SelectSqlQuery":
            return Optional.ofNullable(clazz.cast(selectSqlQuery()));
        case "ResourceRole":
            return Optional.ofNullable(clazz.cast(resourceRole()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "DataPipelineId":
            return Optional.ofNullable(clazz.cast(dataPipelineId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSMetadata, T> g) {
        return obj -> g.apply((RDSMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDSMetadata> {
        /**
         * <p>
         * The database details required to connect to an Amazon RDS.
         * </p>
         * 
         * @param database
         *        The database details required to connect to an Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(RDSDatabase database);

        /**
         * <p>
         * The database details required to connect to an Amazon RDS.
         * </p>
         * This is a convenience that creates an instance of the {@link RDSDatabase.Builder} avoiding the need to create
         * one manually via {@link RDSDatabase#builder()}.
         *
         * When the {@link Consumer} completes, {@link RDSDatabase.Builder#build()} is called immediately and its result
         * is passed to {@link #database(RDSDatabase)}.
         * 
         * @param database
         *        a consumer that will call methods on {@link RDSDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #database(RDSDatabase)
         */
        default Builder database(Consumer<RDSDatabase.Builder> database) {
            return database(RDSDatabase.builder().applyMutation(database).build());
        }

        /**
         * Sets the value of the DatabaseUserName property for this object.
         *
         * @param databaseUserName
         *        The new value for the DatabaseUserName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUserName(String databaseUserName);

        /**
         * <p>
         * The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if <code>Verbose</code> is
         * true in <code>GetDataSourceInput</code>.
         * </p>
         * 
         * @param selectSqlQuery
         *        The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if
         *        <code>Verbose</code> is true in <code>GetDataSourceInput</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectSqlQuery(String selectSqlQuery);

        /**
         * <p>
         * The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task from
         * Amazon RDS to Amazon S3. For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * 
         * @param resourceRole
         *        The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy
         *        task from Amazon RDS to Amazon S3. For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role
         *        templates</a> for data pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRole(String resourceRole);

        /**
         * <p>
         * The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the copy
         * task from Amazon RDS to Amazon S3. For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * 
         * @param serviceRole
         *        The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the
         *        copy task from Amazon RDS to Amazon S3. For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role
         *        templates</a> for data pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You can
         * use the ID to find details about the instance in the Data Pipeline console.
         * </p>
         * 
         * @param dataPipelineId
         *        The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3.
         *        You can use the ID to find details about the instance in the Data Pipeline console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPipelineId(String dataPipelineId);
    }

    static final class BuilderImpl implements Builder {
        private RDSDatabase database;

        private String databaseUserName;

        private String selectSqlQuery;

        private String resourceRole;

        private String serviceRole;

        private String dataPipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSMetadata model) {
            database(model.database);
            databaseUserName(model.databaseUserName);
            selectSqlQuery(model.selectSqlQuery);
            resourceRole(model.resourceRole);
            serviceRole(model.serviceRole);
            dataPipelineId(model.dataPipelineId);
        }

        public final RDSDatabase.Builder getDatabase() {
            return database != null ? database.toBuilder() : null;
        }

        @Override
        public final Builder database(RDSDatabase database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(RDSDatabase.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        public final String getDatabaseUserName() {
            return databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final String getResourceRole() {
            return resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getDataPipelineId() {
            return dataPipelineId;
        }

        @Override
        public final Builder dataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
            return this;
        }

        public final void setDataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
        }

        @Override
        public RDSMetadata build() {
            return new RDSMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
