/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictResponse extends MachineLearningResponse implements
        ToCopyableBuilder<PredictResponse.Builder, PredictResponse> {
    private static final SdkField<Prediction> PREDICTION_FIELD = SdkField.<Prediction> builder(MarshallingType.SDK_POJO)
            .getter(getter(PredictResponse::prediction)).setter(setter(Builder::prediction)).constructor(Prediction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prediction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTION_FIELD));

    private final Prediction prediction;

    private PredictResponse(BuilderImpl builder) {
        super(builder);
        this.prediction = builder.prediction;
    }

    /**
     * Returns the value of the Prediction property for this object.
     * 
     * @return The value of the Prediction property for this object.
     */
    public Prediction prediction() {
        return prediction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prediction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictResponse)) {
            return false;
        }
        PredictResponse other = (PredictResponse) obj;
        return Objects.equals(prediction(), other.prediction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PredictResponse").add("Prediction", prediction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prediction":
            return Optional.ofNullable(clazz.cast(prediction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictResponse, T> g) {
        return obj -> g.apply((PredictResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo, CopyableBuilder<Builder, PredictResponse> {
        /**
         * Sets the value of the Prediction property for this object.
         *
         * @param prediction
         *        The new value for the Prediction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prediction(Prediction prediction);

        /**
         * Sets the value of the Prediction property for this object.
         *
         * This is a convenience that creates an instance of the {@link Prediction.Builder} avoiding the need to create
         * one manually via {@link Prediction#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prediction.Builder#build()} is called immediately and its result
         * is passed to {@link #prediction(Prediction)}.
         * 
         * @param prediction
         *        a consumer that will call methods on {@link Prediction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prediction(Prediction)
         */
        default Builder prediction(Consumer<Prediction.Builder> prediction) {
            return prediction(Prediction.builder().applyMutation(prediction).build());
        }
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private Prediction prediction;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictResponse model) {
            super(model);
            prediction(model.prediction);
        }

        public final Prediction.Builder getPrediction() {
            return prediction != null ? prediction.toBuilder() : null;
        }

        @Override
        public final Builder prediction(Prediction prediction) {
            this.prediction = prediction;
            return this;
        }

        public final void setPrediction(Prediction.BuilderImpl prediction) {
            this.prediction = prediction != null ? prediction.build() : null;
        }

        @Override
        public PredictResponse build() {
            return new PredictResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
